<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace AppBundle\Utils;

/**
 * Description of ReporteLayout
 *
 * @author jose
 */
class ReporteLayout extends \FPDF {
    
    private $container;
    var $widths;
    var $aligns;
    var $profesor = null;
    var $acta = null;
    var $sede = null;
    
    public function setContainer($container)
    {
        $this->container = $container;
    }
    
    
    public function Header() {

        $path = $this->container->getParameter('directorio.imagenes'); 
        $file = $path.'upel.png';
        $this->Image($file, -7, 5, 50,30, 'PNG');
        $txt = "República Bolivariana de Venezuela \n"
                . "Universidad Pedagógica Experimental Libertador \n"
                . "Secretaría - Control de Estudios ";
       

        $this->SetFont('helvetica','',9);
        $this->SetY(12);
        $this->SetX(30);
        $this->MultiCell(140, 4, utf8_decode($txt), 0);
        $this->SetY(12);
        $this->SetX(170);        
        $fecha = new \DateTime();
        $segTxt = "Fecha: ".$fecha->format('d-m-Y')."\n ";
        if($this->acta!=null)
            $segTxt .= "Acta Nro: ".$this->acta;
                
        $this->MultiCell(32, 4, $segTxt, 0, 'R');
        $this->Ln(20);
        //parent::Header();
    }
    


    public function Footer() {
        $this->SetY(-10);
        $this->SetFont('helvetica','',9);
        $this->AliasNbPages();
        $this->Cell(160, 5, utf8_decode(($this->profesor!=null)?'Realizado por: '.$this->profesor:''), 'T',0,'L');
        $this->Cell(30, 5, utf8_decode('Página: ').$this->PageNo().' de {nb}', 
               'T',0,'R');

    }

    function SetWidths($w)
    {
        //Set the array of column widths
        $this->widths=$w;
    }

    function SetAligns($a)
    {
        //Set the array of column alignments
        $this->aligns=$a;
    }
    
    function setProfesor($profesor){
        $this->profesor = $profesor;
    }

    function setSede($sede){
        $this->sede = $sede;
    }
    function setActa($acta){
        $this->acta = $acta;
    }

    function RowTitles($data, $border = 1, $fill=1)
    {
        //Calculate the height of the row
        $nb=0;
        $this->SetFillColor(229,229,229);
        for($i=0;$i<count($data);$i++)
        {
            $w=$this->widths[$i];
            $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
            $this->Cell($w, 6, utf8_decode($data[$i]),$border,0, $a, $fill);
        }
        $this->SetFillColor(null);
        $this->Ln();
    }
    
    function RowBorders($data, $border = 1)
    {
        //Calculate the height of the row
        $nb=0;
        for($i=0;$i<count($data);$i++)
            $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
        $h=5*$nb;
        //Issue a page break first if needed
        $this->CheckPageBreak($h);
        //Draw the cells of the row
        for($i=0;$i<count($data);$i++)
        {
            $w=$this->widths[$i];
            $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
            //Save the current position
            $x=$this->GetX();
            $y=$this->GetY();
            //Draw the border
            
            if($border){
                $this->Rect($x,$y,$w,$h);
                //$this->SetFillColor(null);
            }
            
            //Print the text
            $this->MultiCell($w,5,utf8_decode($data[$i]),0,$a);
            if($border){
                $this->Line($x, $y, $x+$w, $y);
            }
            //Put the position to the right of the cell
            $this->SetXY($x+$w,$y);
            
        }
        //Go to the next line
        $this->Ln($h);
    }
    
    function titleReport($title)
    {
        $sum = 0;
        foreach ($this->widths as $t){
            $sum += $t;
        }
        $this->SetFont('helvetica','B',12);
        $this->Cell($sum,5,  utf8_decode($title), 0, 1, 'C');
        $this->Ln(5);
    }
    
    function headerPageInfo($dataHeader, $border = 0){
        $sum = 0;
        foreach ($this->widths as $t){
            $sum += $t;
        }
        $text = "";
        foreach ($dataHeader as $index =>$value)
        {
            $text .= utf8_decode($index).': '.utf8_decode($value)." \n";
        }
        $this->SetFont('helvetica','B',9);
        $this->MultiCell($sum, 4, $text,$border, 'B');
        $this->Ln(3);
    }


     function TextPageInfo($title)
     {
        $sum = 0;
        foreach ($this->widths as $t){
            $sum += $t;
        }


        $this->SetFont('helvetica','',9);
        $this->MultiCell($sum, 4 ,utf8_decode($title),'J');
        $this->Ln(3);
    }


















    
    function CheckPageBreak($h)
    {
        //If the height h would cause an overflow, add a new page immediately
        if($this->GetY()+$h>$this->PageBreakTrigger)
            $this->AddPage($this->CurOrientation);
    }

    function NbLines($w,$txt)
    {
        //Computes the number of lines a MultiCell of width w will take
        $cw=&$this->CurrentFont['cw'];
        if($w==0)
            $w=$this->w-$this->rMargin-$this->x;
        $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
        $s=str_replace("\r",'',$txt);
        $nb=strlen($s);
        if($nb>0 and $s[$nb-1]=="\n")
            $nb--;
        $sep=-1;
        $i=0;
        $j=0;
        $l=0;
        $nl=1;
        while($i<$nb)
        {
            $c=$s[$i];
            if($c=="\n")
            {
                $i++;
                $sep=-1;
                $j=$i;
                $l=0;
                $nl++;
                continue;
            }
            if($c==' ')
                $sep=$i;
            $l+=$cw[$c];
            if($l>$wmax)
            {
                if($sep==-1)
                {
                    if($i==$j)
                        $i++;
                }
                else
                    $i=$sep+1;
                $sep=-1;
                $j=$i;
                $l=0;
                $nl++;
            }
            else
                $i++;
        }
        return $nl;
    }
    
    
    
}
