<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;

class PlanEstudioType extends AbstractType
{
    private $em;
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder            
            ->add('plan')
            ->add('semestre')                   
            ->add('niveles', 'entity', array(
                'class'=>'AppBundle:Niveles',
                'em'=>$this->em,    
                 'empty_value'=>'.:Seleccione:.'             
            ))            
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\PlanEstudio'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_planestudio';
    }
}
