<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;
use AppBundle\Form\EventListener\AddEspecialidadFieldSubscriber;
use AppBundle\Form\EventListener\AddCursoFieldSubscriber;

class EspeEstudType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    private $em;
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $factory = $builder->getFormFactory();
        $especialidadSubscriber = new AddEspecialidadFieldSubscriber($factory, $this->em);
        $builder->addEventSubscriber($especialidadSubscriber);        
        $builder
            ->add('programa', 'entity', array(
                'class'=>'AppBundle:Programa',
                'empty_value'=>'.:Seleccione:.',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control')
            ))    
            
            ->add('especialidad', 'entity', array(
                'class'=>'AppBundle:especialidad',
                'empty_value'=>'.:Seleccione:.',
                'em'=>$this->em,                
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                    $q = $er->createQueryBuilder('e')
                            ->innerJoin('e.programa', 'p')
                            ->where('p.nombre = :programa ')
                            ->setParameter('programa', null);
                    return $q;
                },
                'attr'=>array('class'=>'form-control' ),
                'required'=>true,
            ))    
            
            ->add('ingreso', 'entity', array(
                'label'=>'Tipo de Ingreso',      
                'class'=>'AppBundle:TipoIngreso',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control')
            ))
            ->add('cohorte', 'entity', array(                
                'class'=>'AppBundle:Cohorte',
                'em'=>$this->em,
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                    $q = $er->createQueryBuilder('c')
                            ->orderBy('c.codigo', 'DESC')
                            ;
                    return $q;
                },
                'attr'=>array('class'=>'form-control')
            ))            
            ->add('cod_lapso', 'entity', array(
                'class'=>'AppBundle:Lapso',
                'em'=>$this->em,
                'query_builder'=>function(\Doctrine\ORM\EntityRepository $er) {
                    $q = $er->createQueryBuilder('l')
                            ->orderBy('l.codigo', 'DESC')
                            ;
                    return $q;
                },
                'attr'=>array('class'=>'form-control'),
                'label'=>'Lapso'
            ))
            ->add('cod_situa', 'entity', array(
                'class'=>'AppBundle:CodSitua',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control'),
                'label'=>'Situación'
            ))
            ->add('subsede', 'entity', array(
                'class'=>'AppBundle:SubSede',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control'),
                'label'=>'Extensión'
            ))

	    ->add('sede', 'entity', array(
                'class'=>'AppBundle:Sede',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control'),
                'label'=>'Sede'
            ))

            ->add('fecha_ingreso','date', array(
                'input' => 'datetime',
                'widget'=> 'single_text',
                'format'=> 'dd-MM-yyyy',
                'attr' => array('placeholder' => 'dd-mm-yyyy', 'class'=>'form-control'),
                'required'=>true
             ))
            ->add('activo', 'checkbox', array('required'=>false,'attr'=>array('class'=>'checkbox-inline')))
            ->add('observacion', 'textarea', array(
                'attr' => array('placeholder' => '', 'class'=>'form-control'),
                'label'=>'Observación',
                'required'=>false
            ))
        ;
        
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\EspeEstud'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_espeestud';
    }
}
