<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;

class CursosType extends AbstractType
{
    
    private $em;
    
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('codigo')
            ->add('nombre')
            ->add('uc')
            ->add('observacion')
            ->add('had')
            ->add('hle')
            ->add('componentes', 'entity', array(
                'class'=>'AppBundle:Componentes',
                'em'=>$this->em,
                 'empty_value'=>'.:Seleccione:.' 
            ))
            ->add('areas', 'entity', array(
                'class'=>'AppBundle:Areas',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.'            
            ))
            ->add('tipocursos', 'entity', array(
                'class'=>'AppBundle:TipoCursos',
                'em'=>$this->em,
                'empty_value'=>'.:Seleccione:.'                
            ))    
            //->add('sede')
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Cursos'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_cursos';
    }
}
