<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;

class CursosEspecialesType extends AbstractType
{
    private $em;
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }
    
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('uc')
            ->add('curso','entity', array(
                'class'=>'AppBundle:Cursos',
                'em'   => $this->em,
                'query_builder'=>function(EntityRepository $er){
                    $q = $er->createQueryBuilder('cu')                            
                            ->where('cu.nombre LIKE :text '
                                    . 'OR cu.nombre LIKE :text2 ' 
                                    . 'OR cu.nombre LIKE :text3')
                            ->setParameter('text', '%TRABAJO DE GRADO%')
                            ->setParameter('text2', '%TUTORIA%')
                            ->setParameter('text3', '%TESIS%')
                            ->orderBy('cu.nombre', 'ASC')
                            ;
                    return $q;
                }
            ))
            ->add('modo_transcripcion', 'entity', array(
                'class'=>'AppBundle:ModoTranscripcion',
                'em'   =>$this->em
            ))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\CursosEspeciales'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_cursosespeciales';
    }
}