<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="subsedeespe")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SubSedeEspeRepository")
 */
class SubSedeEspe {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="subsedeespe")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;

    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="subsedeespe")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     *
     * @return SubSedeEspe
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;

        return $this;
    }

    /**
     * Get especialidad
     *
     * @return \AppBundle\Entity\Especialidad
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return SubSedeEspe
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
