<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * CursosRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProcesosRepository extends EntityRepository
{
    public function findProcesoActivoFech($lapso, $proceso)
    {
        $fechaActual = new \DateTime('today');
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT p FROM AppBundle:Procesos p 
                          WHERE 
                          p.codigo = :codigo AND                           
                          p.lapso = :lapso AND 
                          p.fechainicial <= :fechaactual AND 
                          p.fechafinal >= :fechaactual AND 
                          p.estado = :estado                        
                      ")
                       ->setParameter('codigo', $proceso)                       
                       ->setParameter('lapso', $lapso)
                       ->setParameter('fechaactual', $fechaActual)
                       ->setParameter('estado', 1)
                ;
        return $query->getResult();
    }

    public function findByProcesoActivoFech2($lapsoAc)
    {
        $fechaActual = new \DateTime('');
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT l FROM AppBundle:Lapso l 
                          WHERE
                          l.id = :lapsoAc AND                            
                          l.fecha_final >= :fechaactual AND 
                          l.activo = :activo                        
                      ")
                       ->setParameter('lapsoAc', $lapsoAc)                      
                       ->setParameter('fechaactual', $fechaActual)
                       ->setParameter('activo', 1)
                ;
        return $query->getResult();
    }

    public function findProcesoI($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('fechanow', $fechanow)
                       ->setParameter('codigo', "PI")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findProcesoN($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('fechanow', $fechanow)
                       ->setParameter('codigo', "PN")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findProcesoR($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('fechanow', $fechanow)
                       ->setParameter('codigo', "PR")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findOneByProcesoI($lapso){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.lapso = :lapso                        
                        ")
                       ->setParameter('lapso', $lapso)
                       ->setParameter('codigo', "PI")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findOneByProcesoN($lapso){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.lapso = :lapso                         
                        ")
                       ->setParameter('lapso', $lapso)
                       ->setParameter('codigo', "PN")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findOneByProcesoR($lapso){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.lapso = :lapso                        
                        ")
                       ->setParameter('lapso', $lapso)
                       ->setParameter('codigo', "PR")
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findOneByProcesoIN($fechanow, $codigo){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND 
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('fechanow', $fechanow)
                       ->setParameter('codigo', $codigo)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findLapsoIN($id, $lapso, $codigo){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE 
                        p.codigo = :codigo AND
                        p.id != :id AND
                        p.lapso = :lapso                       
                        ")
                       ->setParameter('id', $id)
                       ->setParameter('lapso', $lapso)
                       ->setParameter('codigo', $codigo)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByLapsoEdit($id){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.id = :id                        
                        ")
                       ->setParameter('id', $id)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByProcesoI($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('codigo', 'PI')
                       ->setParameter('fechanow', $fechanow)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByProcesoN($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('codigo', 'PN')
                       ->setParameter('fechanow', $fechanow)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByProcesoR($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT p FROM AppBundle:Procesos p  
                        WHERE
                        p.codigo = :codigo AND
                        p.fechainicial <= :fechanow AND
                        p.fechafinal >= :fechanow            
                        ")
                       ->setParameter('codigo', 'PR')
                       ->setParameter('fechanow', $fechanow)
                       ->getResult();
                       ;
        return $query;
    }
    
}
