<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * OfertAcadeRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class OfertAcadeRepository extends EntityRepository
{
    public function findCursoTrans($sede, $prof, $lapso){
        $query = $this->getEntityManager()->createQuery("
            SELECT  o FROM AppBundle:OfertAcade o 
            WHERE o.profesor = :prof AND 
                  o.sede = :sede AND 
                  o.lapso = :lapso ")
                ->setParameter('prof', $prof)
                ->setParameter('sede', $sede)
                ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }
    
    public function findCursoOfertado($especialidad, $lapso, $sede, $estudiante){
        $matAprobadas = $this->getEntityManager()->createQuery("
            SELECT h FROM AppBundle:HistMatri h 
            WHERE h.condicion = :condicion AND 
                  h.estudiante = :estudiante
            ")->setParameter('condicion', 3)
              ->setParameter('estudiante', $estudiante->getId())->getResult();
    $mat = array();    
    $i = 0;
    foreach ($matAprobadas as $value){
        $mat[$i]= $value->getCurso()->getId();
        $i++;
    }
        
        $query = $this->getEntityManager()->createQuery("
            SELECT c, o FROM AppBundle:Cursos c            
            LEFT JOIN c.oferacade o 
            WHERE o.especialidad = :especialidad AND 
                  o.lapso = :lapso AND 
                  o.sede = :sede AND 
                  o.cantidad_cupos != o.cantidad_alumnos AND 
                  o.subsede =:subsede AND 
                  o.curso NOT IN(:mat)                   
                  ORDER BY o.curso, o.seccion ASC")
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)         
                ->setParameter('subsede', $estudiante->getSubsede());             
                 //o.cohorte = :cohorte AND 
                //->setParameter('cohorte', $estudiante->getCohorte())
                       
                if(count($mat)==0) $mat[0]=0;
                
                $query->setParameter('mat', $mat)          
                ;
        return $query->getResult();
        
    }
    
    //NUEVO METODO
    public function findCursoOfertadoNew($especialidad, $lapso, $sede, $estudiante, $subsede)
    {
        $em = $this->getEntityManager();


        $sql = $em->createQuery(''
                . 'SELECT c, o FROM AppBundle:Cursos c '
                . 'LEFT JOIN c.oferacade o '
                . 'WHERE '
		. 'o.subsede = :subsede AND '
                . 'o.especialidad = :especialidad AND '
                . 'o.lapso = :lapso AND '
                . 'o.sede = :sede AND '
                . 'o.curso NOT IN (SELECT IDENTITY (h.curso) FROM AppBundle:HistMatri h WHERE '
                . 'h.estudiante = :estudiante AND '
                . 'h.condicion = :condicion) '
                )
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', 1)
                ->setParameter('estudiante', $estudiante)
		->setParameter('subsede', $subsede)
                ->setParameter('condicion', 3)
                ;
        
        return $sql->getResult();
    }
//
    public function findCursoOfertadoNew2($especialidad, $lapso, $sede, $estudiante, $subsede)
    {
        $em = $this->getEntityManager();


        $sql = $em->createQuery(''
                . 'SELECT c, o FROM AppBundle:Cursos c '
                . 'LEFT JOIN c.oferacade o '
                . 'WHERE '
		        . 'o.subsede = :subsede AND '
                . 'o.especialidad = :especialidad AND '
                . 'o.lapso = :lapso AND '
                . 'o.sede = :sede AND '
                . 'o.curso NOT IN (SELECT IDENTITY (h.curso) FROM AppBundle:HistMatri h WHERE '
                . 'h.estudiante = :estudiante AND '
                . 'h.condicion = :condicion) AND '
                . 'o.curso IN (SELECT IDENTITY (a.curso) FROM AppBundle:Asesoria a WHERE a.estudiante = :estudiante AND a.lapso = :lapso)'
                )
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', 1)
                ->setParameter('estudiante', $estudiante)
		        ->setParameter('subsede', $subsede)
                ->setParameter('condicion', 3)
                ;
        
        return $sql->getResult();
    }

    public function findCursoOfertadoNew3($cohorte, $especialidad, $lapso, $sede, $estudiante, $subsede)
    {
        $em = $this->getEntityManager();


        $sql = $em->createQuery(''
                . 'SELECT c, o FROM AppBundle:Cursos c '
                . 'LEFT JOIN c.oferacade o '
                . 'WHERE '
                . 'o.subsede = :subsede AND '
                . 'o.especialidad = :especialidad AND '
                . 'o.lapso = :lapso AND '
                . 'o.cohorte = :cohorte AND '
                . 'o.sede = :sede AND '
                . 'o.curso NOT IN (SELECT IDENTITY (h.curso) FROM AppBundle:HistMatri h WHERE '
                . 'h.estudiante = :estudiante AND '
                . 'h.condicion = :condicion) '
                )
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('cohorte', $cohorte)
                ->setParameter('sede', 1)
                ->setParameter('estudiante', $estudiante)
                ->setParameter('subsede', $subsede)
                ->setParameter('condicion', 3)
                ;
        
        return $sql->getResult();
    }
    //usado
    public function updateOfertaMasUn($id){
       $oferta = $this->getEntityManager()->createQuery("
                        SELECT o.cantidad_alumnos FROM AppBundle:OfertAcade o 
                        WHERE o.id = :id 
                       ")->setParameter('id', $id)
                         ->getResult();
               
       $alumnos = $oferta[0]['cantidad_alumnos'] + 1;
       $query = $this->createQueryBuilder('o')
                     ->update('AppBundle:OfertAcade', 'o')
                     ->set('o.cantidad_alumnos', $alumnos)
                     ->where('o.id = :id')
                     ->setParameter('id', $id)
                     ->getQuery()->execute();
    }
    //usado
    public function updateOfertaMenosUn($id){
       $oferta = $this->getEntityManager()->createQuery("
                        SELECT o.cantidad_alumnos FROM AppBundle:OfertAcade o 
                        WHERE o.id = :id 
                       ")->setParameter('id', $id)
                         ->getResult();
               
       $alumnos = $oferta[0]['cantidad_alumnos'] - 1;
       $query = $this->createQueryBuilder('o')
                     ->update('AppBundle:OfertAcade', 'o')
                     ->set('o.cantidad_alumnos', $alumnos)
                     ->where('o.id = :id')
                     ->setParameter('id', $id)
                     ->getQuery()->execute();
    }
    
    public function consultAlumsInscritos($especialidad, $curso, $seccion, $lapso, $sede)
    {
        if($lapso>=1000){
        $query = $this->getEntityManager()->createQuery(
                "SELECT o, m FROM AppBundle:OfertAcade o                  
                 LEFT JOIN o.matricula m 
                 LEFT JOIN m.estudiante da 
                 LEFT JOIN da.validestud v 
                 LEFT JOIN da.estudiante est 
                 WHERE o.curso = :curso AND 
                       o.especialidad = :especialidad AND 
                       o.seccion = :seccion AND 
                       o.lapso = :lapso AND 
                       o.sede = :sede AND
                       v.lapso = :lapso2
                       ORDER BY est.cedula ASC
                       "
                )
                ->setParameter('curso', $curso)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('seccion', $seccion)
                ->setParameter('lapso', $lapso)
                ->setParameter('lapso2', $lapso)
                ->setParameter('sede', $sede);
        }else{
            $query = $this->getEntityManager()->createQuery(
                "SELECT o, m FROM AppBundle:OfertAcade o                  
                 LEFT JOIN o.matricula m 
                 LEFT JOIN m.estudiante da                 
                 LEFT JOIN da.estudiante est 
                 WHERE o.curso = :curso AND 
                       o.especialidad = :especialidad AND 
                       o.seccion = :seccion AND 
                       o.lapso = :lapso AND 
                       o.sede = :sede                       
                       ORDER BY est.cedula ASC
                       "
                )
                ->setParameter('curso', $curso)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('seccion', $seccion)
                ->setParameter('lapso', $lapso)                
                ->setParameter('sede', $sede);
        }
        if(count($query->getResult())==0)
            return false;
            
        
        return $query->getSingleResult();                
    }
    
    public function consultOfertaPorLotes($especialidad, $lapso, $sede)
    {
        $query = $this->getEntityManager()
                ->createQuery("
                SELECT o, m FROM AppBundle:OfertAcade o 
                LEFT JOIN o.matricula m 
                LEFT JOIN m.estudiante da 
                LEFT JOIN da.estudiante est 
                WHERE 
                o.especialidad = :especialidad AND 
                o.lapso = :lapso AND 
                o.sede = :sede AND 
                o.cantidad_alumnos != :cantinsc 
                ORDER BY o.curso, o.seccion, est.cedula ASC
                ")
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('cantinsc', 0)
                ;
        return $query->getResult();
    }
    
    public function findByAllOferta($especialidad, $lapso, $sede, $subsede)
    {
        $query = $this->getEntityManager()
                ->createQuery("
                 SELECT e, o FROM AppBundle:Especialidad e 
                 LEFT JOIN e.oferacade o 
                 WHERE 
                 o.especialidad = :especialidad AND 
                 o.lapso = :lapso AND 
                 o.sede = :sede   AND 
                 o.subsede = :subsede 
                 ORDER BY o.curso, o.seccion ASC
                ")
                ->setParameter('especialidad', $especialidad)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('subsede', $subsede)
                ;
        return $query->getSingleResult();
    }
    
    public function findOfertaSinTranscribir($especialidad, $lapso, $sede, $impresa)
    {
        $query = $this->getEntityManager()
                ->createQuery("
                  SELECT p, o FROM AppBundle:Profesor p 
                  LEFT JOIN p.oferacade o 
                  LEFT JOIN o.matricula m 
                  WHERE 
                  o.especialidad = :especialidad AND 
                  o.lapso = :lapso AND 
                  o.sede = :sede AND                  
                  m.condicion = :condicion             
                  ORDER BY p.cedula ASC"      
                  )
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('condicion', 2)
                //->setParameter('impresa', $impresa)
                ;
        return $query->getResult();
    }
    
    public function choqueHorario($cursoAInscribir, $matricula = array())
    {
        $choque=false;   
        $hola="";
        $contar = 0;
        
        foreach ($cursoAInscribir as $curso){
            //$hola = var_dump($curso);
            $dias = explode('-', $curso['horario']);
            //$hola = var_dump($dias);
            $id = $curso['oferta'];
            $i=0;
            $e=0;
            $f=0;
            $g=0;
            $cursoAInscribir2 = array();
            while(count($dias)>$i){
                $d[$i]= substr($dias[$i], 0,1);
                $hi[$i]= substr($dias[$i], 1,1);
                $hf[$i]= substr($dias[$i], -1);
                $i++;
            }
            
            $contar = count($cursoAInscribir);
            if(count($cursoAInscribir)>1){
                $cursoAInscribir2 = $cursoAInscribir;
                
                foreach ($cursoAInscribir2 as $ent){
                    if($ent['oferta']!=$id){
                        if($ent['horario']!=""){
                            $diaIns= explode('-', $ent['horario']);

                            $di=array();
                            $hii=array();
                            $hfi=array();
                            while(count($diaIns)>$e){
                                $di[$e]= substr($diaIns[$e], 0,1);
                                $hii[$e]= substr($diaIns[$e], 1,1);
                                $hfi[$e]= substr($diaIns[$e], -1);
                                $e++;
                            }

                            while(count($dias)>$f){
                                $g=0;    
                                while(count($diaIns)>$g){
                                    if($d[$f]==$di[$g]){
                                            if($hi[$f]==$hii[$g]){                           
                                                 $choque = true;                                                                            
                                            }elseif($hi[$f]>$hii[$g]&$hi[$f]<=$hfi[$g]){
                                                $choque = true;
                                            }elseif($hf[$f]>=$hii[$g]&&$hf[$f]<=$hfi[$g]){
                                                $choque = true;
                                            }
                                         }
                                   $g++; 
                                }
                                $f++;
                            }

                        }
                    }
                 }
             }
             
            if(count($matricula)>0){
                foreach ($matricula as $ent){
                    if($ent->getOferta()->getDescripcHorario()!=""){
                        $diaIns= explode('-', $ent->getOferta()->getDescripcHorario());

                        $di=array();
                        $hii=array();
                        $hfi=array();
                        while(count($diaIns)>$e){
                            $di[$e]= substr($diaIns[$e], 0,1);
                            $hii[$e]= substr($diaIns[$e], 1,1);
                            $hfi[$e]= substr($diaIns[$e], -1);
                            $e++;
                        }

                        while(count($dias)>$f){
                            $g=0;    
                            while(count($diaIns)>$g){
                                if($d[$f]==$di[$g]){
                                        if($hi[$f]==$hii[$g]){                           
                                             $choque = true;                                                                            
                                        }elseif($hi[$f]>$hii[$g]&$hi[$f]<=$hfi[$g]){
                                            $choque = true;
                                        }elseif($hf[$f]>=$hii[$g]&&$hf[$f]<=$hfi[$g]){
                                            $choque = true;
                                        }
                                     }
                               $g++; 
                            }
                            $f++;
                        }

                    }
                 }
             }
        }
         if($choque)
             return 0;
            
         return true;
    }
    
    public function genNumActa($lapso, $sede)
    {
        
        $query = $this->getEntityManager()->createQuery
                (
                "SELECT o FROM AppBundle:OfertAcade o 
                 LEFT JOIN o.curso c 
                 WHERE 
                 o.cantidad_alumnos > 0 AND 
                 o.lapso = :lapso AND 
                 o.sede = :sede 
                 ORDER BY c.codigo, o.seccion, o.grupo ASC"
                )
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ;
         $result  = $query->getResult();
         
         
         $i = 1;
         foreach ($result as $em)
         {
              $query = $this->createQueryBuilder('o')
                     ->update('AppBundle:OfertAcade', 'o')
                     ->set('o.numero_acta', $i)
                     ->where('o.id = :id')
                     ->setParameter('id', $em->getId())
                     ->getQuery()->execute();
             $i++;
         }
         
         return true;
    
    }
    
    public function findAllOfertaAcademica($programa, $especialidad, $lapso, $sede, $subsede, $cohorte){
         $query = 'SELECT o FROM AppBundle:OfertAcade o '
                 . 'WHERE '
                 . 'o.programa = :programa AND '
                 . 'o.especialidad = :especialidad AND '
                 . 'o.lapso = :lapso AND '
                 . 'o.sede = :sede AND '
                 . 'o.subsede = :subsede ' 
                 ;
         if($cohorte != NULL ){
             $query .= 'AND o.cohorte = :cohorte ';
         }
         $query .= 'ORDER BY o.curso, o.seccion ASC ';
         
         $consulta = $this ->getEntityManager()->createQuery($query);
         $consulta->setParameter('programa', $programa)
         ->setParameter('especialidad', $especialidad)
         ->setParameter('lapso', $lapso)
         ->setParameter('sede', $sede)        
         ->setParameter('subsede', $subsede);
        
         if($cohorte != NULL)
         {
             $consulta->setParameter('cohorte', $cohorte);
         }       
         
         
         return $consulta->getResult();    
    }
    
    //nuevo
    public function findOfertaSinTranscribirA($especialidad, $cohorte, $lapso, $sede, $subsede, $impresa=null)
    {
        $query = $this->getEntityManager()
                ->createQuery("
                  SELECT p, o FROM AppBundle:Profesor p 
                  LEFT JOIN p.oferacade o 
                  LEFT JOIN o.matricula m 
                  WHERE 
                  o.especialidad = :especialidad AND 
                  o.cohorte = :cohorte AND
                  o.lapso = :lapso AND 
                  o.sede = :sede AND
                  o.subsede = :subsede AND                  
                  m.condicion = :condicion AND 
                  p.cedula != :noasignado 
                  ORDER BY p.cedula ASC"      
                  )
                ->setParameter('cohorte', $cohorte)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('subsede', $subsede)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('condicion', 2)
                ->setParameter('noasignado', '1')
                //->setParameter('impresa', $impresa)
                ;
        return $query->getResult();
    }

    public function findOfertaSinTranscribirG($lapso, $sede, $subsede, $impresa=null)
    {
        $query = $this->getEntityManager()
                ->createQuery("
                  SELECT p, o FROM AppBundle:Profesor p 
                  LEFT JOIN p.oferacade o 
                  LEFT JOIN o.matricula m 
                  WHERE 
                  o.lapso = :lapso AND
                  o.sede = :sede AND
                  o.subsede = :subsede AND                  
                  m.condicion = :condicion AND 
                  p.cedula != :noasignado 
                  ORDER BY o.cohorte ASC"      
                  )
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('subsede', $subsede)
                ->setParameter('condicion', 2)
                ->setParameter('noasignado', '1')
                ;
        return $query->getResult();
    }
    
    //nuevo
    public function findCursoTransNew($prof, $lapso){
        $query = $this->getEntityManager()->createQuery("
            SELECT  o FROM AppBundle:OfertAcade o 
            WHERE o.profesor = :prof AND 
                  o.lapso = :lapso ")
                ->setParameter('prof', $prof)
                ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }
    
    //nuevo
    public function findOfertaCurSec($prof, $especialidad, $lapso, $sede, $subsede){
        $query = $this->getEntityManager()->createQuery("
            SELECT  o FROM AppBundle:OfertAcade o
            LEFT JOIN o.curso c 
            WHERE o.profesor = :prof AND
                  o.especialidad = :especialidad AND 
                  o.lapso = :lapso AND 
                  o.sede = :sede AND
                  o.subsede = :subsede 
                  ORDER BY o.seccion ASC")
                ->setParameter('prof', $prof)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('subsede', $subsede)
                ->setParameter('especialidad', $especialidad)
                ;
        return $query->getResult();
    }

    public function findOfertaCurSecCoh($prof, $lapso, $sede, $subsede){
        $query = $this->getEntityManager()->createQuery("
            SELECT  o FROM AppBundle:OfertAcade o
            LEFT JOIN o.curso c 
            WHERE o.profesor = :prof AND
                  o.lapso = :lapso AND 
                  o.sede = :sede AND
                  o.subsede = :subsede 
                  ORDER BY o.cohorte ASC")
                ->setParameter('prof', $prof)
                ->setParameter('lapso', $lapso)
                ->setParameter('sede', $sede)
                ->setParameter('subsede', $subsede)
                ;
        return $query->getResult();
    }

    //nuevo
    public function findByOfertaMat($oferta){
        $query = $this->getEntityManager()->createQuery("
            SELECT  m FROM AppBundle:Matricula m
            LEFT JOIN m.oferta o
            LEFT JOIN m.condicion c
            WHERE m.oferta = :oferta")
                ->setParameter('oferta', $oferta)
                ;
        return $query->getResult();
    }

    public function findAllOfertaListadoClase($profesor, $lapso){
         $query = 'SELECT o FROM AppBundle:OfertAcade o '
                 . 'WHERE '
                 . 'o.profesor = :profesor AND '
                 . 'o.lapso = :lapso '
                 ;
         $query .= 'ORDER BY o.curso, o.seccion ASC ';
         
         $consulta = $this ->getEntityManager()->createQuery($query);
         $consulta->setParameter('profesor', $profesor);
         $consulta->setParameter('lapso', $lapso);
          
         return $consulta->getResult();    
    }

    public function totalOfertaAcademica($lapso, $subsede){
         $query = 'SELECT o FROM AppBundle:OfertAcade o '
                 . 'WHERE '
                 . 'o.lapso = :lapso AND '
                 . 'o.subsede = :subsede ' 
                 ;
         $query .= 'ORDER BY o.cohorte, o.curso, o.seccion, o.especialidad ASC ';
         
         $consulta = $this ->getEntityManager()->createQuery($query);
         $consulta
                   ->setParameter('lapso', $lapso)       
                   ->setParameter('subsede', $subsede);
         
         return $consulta->getResult();    
    }
}
