<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * MatriculaRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class MatriculaRepository extends EntityRepository
{
    //nuevo
    public function findMatriculaEstudiante($estudiante, $lapso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND 
                        o.lapso = :lapso    
                        ")
                        ->setParameter('estudiante', $estudiante)
                        ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }


    public function findMatriculaEstudianteReport($estudiante, $lapso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND
                        o.lapso = :lapso    
                        ")
                        ->setParameter('estudiante', $estudiante)
                        ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }

    //usados en el nuevo
    public function findMatriculaEstudianteLapso($estudiante, $lapso, $curso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND                         
                        o.curso = :curso AND 
                        o.lapso = :lapso")
                       ->setParameter('estudiante', $estudiante)                       
                       ->setParameter('curso', $curso)
                       ->setParameter('lapso', $lapso)
                ;
        return $query->getScalarResult();
    }
    
    public function findMatriculaEstudAprob($estudiante)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT m FROM AppBundle:Matricula m 
                          WHERE 
                          m.estudiante = :estudiante AND 
                          m.condicion = :condicion
                          ")
                       ->setParameter('estudiante', $estudiante)
                       ->setParameter('condicion', 3);
        return $query->getResult();
    }

    public function findMatriculaEstudAplazado($estudiante)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT m FROM AppBundle:Matricula m 
                          WHERE 
                          m.estudiante = :estudiante AND 
                          m.condicion = :condicion
                          ")
                       ->setParameter('estudiante', $estudiante)
                       ->setParameter('condicion', 4);
        return $query->getResult();
    }
    
    public function findAlumnosByCurso($curso)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :curso
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('curso', $curso);
        return $query->getResult();
                       
    }
    
    public function findMatriculaEstudianteReg($estudiante, $lapso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND 
                        o.lapso = :lapso    
                        ")
                        ->setParameter('estudiante', $estudiante)
                        ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }
    
    public function findByAlumInscritos($programa, $lapso)
    {
        $query = $this->getEntityManager()
                ->createQuery(
                 "SELECT e, esp FROM AppBundle:Especialidad e 
                  LEFT JOIN e.espeestud esp 
                  LEFT JOIN esp.matricula m 
                  LEFT JOIN m.oferta o
                  WHERE 
                  e.programa = :programa AND                  
                  o.lapso = :lapso 
                  "       
                 )
                ->setParameter('programa', $programa)
                //->setParameter('situa', 1)
                ->setParameter('lapso', $lapso)
                ;
//        $query = $this->getEntityManager()
//                ->createQuery(
//                 "SELECT e, esp FROM AppBundle:Especialidad e 
//                  LEFT JOIN e.espeestud esp 
//                  LEFT JOIN esp.matricula m 
//                  WHERE 
//                  esp.programa = :programa AND 
//                  esp.cod_situa = :situa AND 
//                  esp.cod_lapso = :lapso "       
//                 )
//                ->setParameter('programa', $programa)
//                ->setParameter('situa', 1)
//                ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();        
    }
    
    public function findByMatriculaHist($lapso){
        $query = $this->getEntityManager()
                 ->createQuery("
                 SELECT m, o FROM AppBundle:Matricula m 
                 LEFT JOIN m.oferta o 
                 WHERE 
                 m.condicion != :condicion AND 
                 o.lapso = :lapso 
                 ")
                ->setParameter('condicion', 2)
                ->setParameter('lapso', $lapso);               
        return $query->getResult();
    }
    
    public function findByMatriculaHistInsc($lapso){
        $query = $this->getEntityManager()
                ->createQuery("
                SELECT m, o FROM AppBundle:Matricula m
                LEFT JOIN m.oferta o 
                WHERE 
                m.condicion = :condicion AND 
                o.lapso = :lapso 
                ")
                ->setParameter('condicion', 2)
                ->setParameter('lapso', $lapso);
        return $query->getResult();
    }

    public function getMontoInscritoEstudiante($matricula, $em, $configPrograma){
    $montoInscrito = 0;
        //if($configPrograma->getControlpago()){
            foreach ($matricula as $ent){                
                $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ent->getOferta()->getCurso(), 'modo_transcripcion'=>'2'));
                $costouc = $configPrograma->getMontouc();
                
                if(!$cursoespecial){
                    $costouc = ($costouc * $configPrograma->getPorcentajeuc()); 
                }                    
                if($cursoespecial){
                $uccurso = $cursoespecial->getUc();
                }else{
                    
                $uccurso = $ent->getOferta()->getCurso()->getUc();
                
                }  
                $montoInscrito = $montoInscrito + ($costouc*$uccurso);
            }
        //}
            return $montoInscrito;
    }
    
    public function getUcInscritas($em,$matricula){
        $ucInscrito = 0;
            foreach ($matricula as $ent){                
                $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ent->getOferta()->getCurso()));
                                                 
                if($cursoespecial){
                //$uccurso = $cursoespecial->getUc();
                }else{                        
                $ucInscrito =$ucInscrito + $ent->getOferta()->getCurso()->getUc();

                }              
                
           }
        return $ucInscrito;
    }
    
    public function getMontoUc($em, $ofert, $configPrograma){
        $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ofert->getCurso()));
        $costouc = $configPrograma->getMontouc();
        if(!$cursoespecial){
            $costouc = ($costouc * $configPrograma->getPorcentajeuc());                           
        }                    
        if($cursoespecial){
        $uccurso = $cursoespecial->getUc();
        }else{
        $uccurso = $ofert->getCurso()->getUc();
        }  
        
        return $montocurso = ($costouc*$uccurso);
    }
    
    /********************
     ***     NUEVO    ***
     ********************/
    
    public function getHistorico($id)
    {
         $query = $this->getEntityManager()
                ->createQuery("
                SELECT m, o FROM AppBundle:Matricula m
                LEFT JOIN m.oferta o 
                WHERE                 
                m.estudiante = :estudiante 
                ")
                ->setParameter('estudiante', $id)
                ;
         
        return $query->getResult();
    }
    
    public function getEstudiantesByOferta($oferta)
    {
        $query = "SELECT m, o FROM AppBundle:Matricula m "
                . "LEFT JOIN m.oferta o "
                . "LEFT JOIN m.estudiante ee "
                . "LEFT JOIN ee.estudiante e "
                . "WHERE "
                . "m.oferta = :oferta "
                . "ORDER BY e.cedula ASC ";
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('oferta', $oferta);
        return $consulta->getResult();
    }
    
    public function getEstudiantesInscritos($cohorte,$lapso, $programa, $subsede)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.estudiante est "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "ee.subsede = :subsede AND "
                . "ee.cohorte = :cohorte AND "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa "
                . "ORDER BY e.nombre ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('lapso', $lapso)
                ->setParameter('cohorte', $cohorte)
                ->setParameter('programa', $programa)
                ->setParameter('subsede', $subsede)
                ;
        return $consulta->getResult();
    }

    public function getEstudiantesInscritosP($lapso, $programa, $subsede)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.estudiante est "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "ee.subsede = :subsede AND "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa "
                . "ORDER BY e.nombre ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('lapso', $lapso)
                ->setParameter('programa', $programa)
                ->setParameter('subsede', $subsede)
                ;
        return $consulta->getResult();
    }
    
    public function getEstudiantesInscritosByEspecialidad($cohorte, $lapso, $programa, $especialidad, $subsede)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.estudiante est "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "ee.subsede = :subsede AND "
                . "ee.cohorte = :cohorte AND "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa AND "
                . "e.id = :especialidad "
                . "ORDER BY est.cedula ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('subsede', $subsede)
                ->setParameter('cohorte', $cohorte)
                ->setParameter('lapso', $lapso)
                ->setParameter('programa', $programa)
                ->setParameter('especialidad', $especialidad)
                ;
        return $consulta->getResult();
    }

    public function getEstudiantesInscritosUDBE($lapso)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.estudiante est "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "o.lapso = :lapso "
                . "ORDER BY est.cedula ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('lapso', $lapso)
                ;
        return $consulta->getResult();
    }

    public function getEstudiantesInscritosByEspecialidad2($cohorte, $lapso, $programa, $especialidad, $subsede)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.estudiante est "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "est.discapacidad != :discapacidad AND "
                . "ee.subsede = :subsede AND "
                . "o.cohorte = :cohorte AND "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa AND "
                . "e.id = :especialidad "
                . "ORDER BY est.cedula ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('subsede', $subsede)
                ->setParameter('cohorte', $cohorte)
                ->setParameter('lapso', $lapso)
                ->setParameter('programa', $programa)
                ->setParameter('especialidad', $especialidad)
                ->setParameter('discapacidad', 1)
                ;
        return $consulta->getResult();
    }

    //nuevo
    public function findAlumnosByCursoA($curso)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m, e FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :curso
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('curso', $curso);
        return $query->getResult();
    }

     //nuevo
    public function findAlumnosByCursoA2($oferta)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m, e FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :oferta and
                           m.condicion in (3,4)
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('oferta', $oferta);
                       
        return $query->getResult();
    }

    public function findAlumnosByCursoA3($oferta)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m, e FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :oferta and
                           m.condicion = '2'
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('oferta', $oferta)
                       ;
                       
        return $query->getResult();
    }

    public function findAlumnosByCursoA4($oferta)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m, e FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :oferta and
                           m.status = 'Incluido'
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('oferta', $oferta)
                       ;
                       
        return $query->getResult();
    }

    public function findOfertaInscritos($oferta)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m FROM AppBundle:Matricula m 
                           WHERE 
                           m.oferta = :oferta and
                           m.condicion = :condicion
                       ")
                       ->setParameter('oferta', $oferta)
                       ->setParameter('condicion', 2)
                       ;
                       
        return $query->getResult();
    }
    
    public function findMatriculaEstudianteRetiro($estudiante)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT m FROM AppBundle:Matricula m 
                          WHERE 
                          m.estudiante = :estudiante AND 
                          m.condicion = :condicion
                          ")
                       ->setParameter('estudiante', $estudiante)
                       ->setParameter('condicion', 2);
        return $query->getResult();
    }


}
