<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ExoneradosRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ExoneradosRepository extends EntityRepository
{
    public function getExeracionEstudiante($estudiante, $lapso){
        $exoneracion = $this->getEntityManager()
                ->createQuery('SELECT e FROM AppBundle:Exonerados e 
                              WHERE e.especialidadEstudiante = :estudiante AND 
                                    e.lapso = :lapso ')
                ->setParameter('estudiante', $estudiante->getId())
                ->setParameter('lapso', $lapso->getid())
                ->getOneOrNullResult(); 
        
        return $exoneracion;
    }
    
    public function findByExoneracionByEspecialidad($especialidad ,$lapso){
        $query = "SELECT e, d, m
                  FROM AppBundle:EspeEstud e 
                  LEFT JOIN e.estudiante ee 
                  LEFT JOIN e.exonerados d 
                  LEFT JOIN e.matricula m 
                  LEFT JOIN m.oferta o 
                  WHERE 
                  e.especialidad = :especialidad AND 
                  d.lapso = :lapso AND 
                  o.lapso = :lapso                   
                  ORDER BY ee.cedula ASC ";
        $qb = $this->getEntityManager()->createQuery($query)
                   ->setParameter('especialidad', $especialidad)
                   ->setParameter('lapso', $lapso)
                ;
        
        return $qb->getResult();
    }
    
}
