<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

use AppBundle\Entity\ControlPagos;
/**
 * ControlPagosRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ControlPagosRepository extends EntityRepository
{
    public function generarControlPagos($estudiante, $lapso, $montoInscripc, $configPrograma)
    {       
        $em = $this->getEntityManager();
        $lasInsertCuotas = $em
                ->createQuery("SELECT c FROM AppBundle:ControlPagos c
                                WHERE c.estudiante =:estudiante AND 
                                      c.lapso = :lapso ")
                ->setParameter('estudiante', $estudiante->getId())
                ->setParameter('lapso', $lapso->getId())
                ->getResult();
        
        if(!$lasInsertCuotas){
            $this->setCuotasPagos($estudiante, $lapso, $em, $montoInscripc, $configPrograma);
        }else{ 
             $suma = 0;
             foreach ($lasInsertCuotas as $value){
                 $suma += $value->getMonto();
             }
            if($montoInscripc != $suma){             

                    foreach ($lasInsertCuotas as $value){
                        $em->remove($value);
                    }
                    $em->flush();
                      
                    $this->setCuotasPagos($estudiante, $lapso, $em, $montoInscripc, $configPrograma);
            }
        }
        
    }
    
    public function setCuotasPagos($estudiante, $lapso, $em, $montoInscripc, $configPrograma){
            $cuota1 = $configPrograma->getCuota1();
            $cuota2 = $configPrograma->getCuota2();
            $cuota3 = $configPrograma->getCuota3();
            
            $montoCuota1 = $montoInscripc * (float)$cuota1/100;
            $montoCuota2 = $montoInscripc * (float)$cuota2/100;
            $montoCuota3 = $montoInscripc * (float)$cuota3/100;
            
            $CONTROLPAGOS1 = new ControlPagos();
            $CONTROLPAGOS1->setCuota("Cuota 1");
            $CONTROLPAGOS1->setMonto($montoCuota1);
            $CONTROLPAGOS1->setEstudiante($estudiante);
            $CONTROLPAGOS1->setLapso($lapso);
            $em->persist($CONTROLPAGOS1);
            
            $CONTROLPAGOS2 = new ControlPagos();
            $CONTROLPAGOS2->setCuota("Cuota 2");
            $CONTROLPAGOS2->setMonto($montoCuota2);
            $CONTROLPAGOS2->setEstudiante($estudiante);
            $CONTROLPAGOS2->setLapso($lapso);
            $em->persist($CONTROLPAGOS2);
            
            $CONTROLPAGOS3 = new ControlPagos();
            $CONTROLPAGOS3->setCuota("Cuota 3");
            $CONTROLPAGOS3->setMonto($montoCuota3);
            $CONTROLPAGOS3->setEstudiante($estudiante);
            $CONTROLPAGOS3->setLapso($lapso);
            $em->persist($CONTROLPAGOS3);            
            
            $em->flush(); 
    }
}
