<?php

namespace AppBundle\Entity\Repository;

/**
 * AsesoriaRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class AsesoriaRepository extends \Doctrine\ORM\EntityRepository
{
    public function findCursoAsesoradoEstudiante($estudiante, $lapso) {
	$em = $this->getEntityManager();
        $query = "SELECT a FROM AppBundle:Asesoria a ".
                 "LEFT JOIN a.estudiante est ".
                 "LEFT JOIN a.lapso l ".
                 "WHERE ".
                 "est.id = :estudiante AND ".
                 "l.id = :lapso ";
        $consult = $em->createQuery($query);
        $consult->setParameter('estudiante', $estudiante);
        $consult->setParameter('lapso', $lapso);
        return $consult->getResult();
    }

    public function getEstudEspecialidadAsesorados($lapso, $programa)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT e.nombre FROM AppBundle:Asesoria ee
                          LEFT JOIN ee.estudiante m
                          LEFT JOIN m.especialidad e 
                          WHERE 
                          ee.lapso = :lapso AND 
                          e.programa = :programa
                          group by e.nombre
                          order by e.nombre ASC   
                      ")
                        ->setParameter('lapso', $lapso)
                        ->setParameter('programa', $programa)
                      ;

        return $query->getResult();
    }

    public function getEstudEspecialidadAsesoradosC($cohorte, $lapso, $programa)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT e.nombre FROM AppBundle:Asesoria ee
                          LEFT JOIN ee.estudiante m
                          LEFT JOIN m.especialidad e 
                          WHERE 
                          ee.lapso = :lapso AND
                          m.cohorte = :cohorte AND 
                          e.programa = :programa
                          group by e.nombre
                          order by e.nombre ASC   
                      ")
                        ->setParameter('lapso', $lapso)
                        ->setParameter('cohorte', $cohorte)
                        ->setParameter('programa', $programa)
                      ;

        return $query->getResult();
    }

    public function findEstudiantesAsesorados($lapso, $programa, $subsede){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT a, ee FROM AppBundle:Asesoria a
                        LEFT JOIN a.estudiante ee
                        LEFT JOIN ee.especialidad e 
                        WHERE 
                        a.lapso = :lapso AND 
                        ee.subsede = :subsede AND 
                        e.programa = :programa
                        order by e.nombre, a.estudiante ASC   
                        ")
                        ->setParameter('lapso', $lapso)
                        ->setParameter('programa', $programa)
                        ->setParameter('subsede', $subsede)
                ;
        return $query->getResult();
    }
}
