<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="matricula")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\MatriculaRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Matricula {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="matricula")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="OfertAcade", inversedBy="matricula")
     * @ORM\JoinColumn(name="oferta_id", referencedColumnName="id")
     */
    protected $oferta;

    /**
     * @ORM\ManyToOne(targetEntity="Traslado", inversedBy="matricula")
     * @ORM\JoinColumn(name="traslado_id", referencedColumnName="id")
     */
    protected $traslado;
    
    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $nota;
    
    /**
     * @ORM\ManyToOne(targetEntity="CondCurso", inversedBy="matricula")
     * @ORM\JoinColumn(name="condicion_id", referencedColumnName="id")
     */
    protected $condicion;
    
    /**
     * @ORM\ManyToOne(targetEntity="Sessiones", inversedBy="matricula")
     * @ORM\JoinColumn(name="session_id", referencedColumnName="id")
     */
    protected $session;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="matricula")
     */
    protected $histmatri;
    

    /**
     * @ORM\Column(type="string", length=30)
     */
    protected $status;

    /**
     * @ORM\Column(type="integer", length=2)
     */
    protected $cargas;

    /**
     * @ORM\PrePersist()
     */
    public function setValue(){
        $this->setNota('1');
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nota
     *
     * @param integer $nota
     * @return Matricula
     */
    public function setNota($nota)
    {
        $this->nota = $nota;
    
        return $this;
    }

    /**
     * Get nota
     *
     * @return string 
     */
    public function getNota()
    {
        return $this->nota;
    }



    /**
     * Set status
     *
     * @param string $status
     * @return Matricula
     */
    public function setStatus($status)
    {
        $this->status = $status;
    
        return $this;
    }

    /**
     * Get status
     *
     * @return integer 
     */
    public function getStatus()
    {
        return $this->status;
    }


    /**
     * Set cargas
     *
     * @param integer $cargas
     * @return Matricula
     */
    public function setCargas($cargas)
    {
        $this->cargas = $cargas;
    
        return $this;
    }

    /**
     * Get cargas
     *
     * @return integer 
     */
    public function getCargas()
    {
        return $this->cargas;
    }



    /**
     * Set estudiante
     *
     * @param AppBundle\Entity\EspeEstud $estudiante
     * @return Matricula
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set oferta
     *
     * @param AppBundle\Entity\OfertAcade $oferta
     * @return Matricula
     */
    public function setOferta(\AppBundle\Entity\OfertAcade $oferta = null)
    {
        $this->oferta = $oferta;
    
        return $this;
    }

    /**
     * Get oferta
     *
     * @return AppBundle\Entity\OfertAcade 
     */
    public function getOferta()
    {
        return $this->oferta;
    }

    /**
     * Set traslado
     *
     * @param AppBundle\Entity\Traslado $traslado
     * @return Matricula
     */
    public function setTraslado(\AppBundle\Entity\Traslado $traslado = null)
    {
        $this->traslado = $traslado;
    
        return $this;
    }

    /**
     * Get traslado
     *
     * @return AppBundle\Entity\trasladocade 
     */
    public function getTraslado()
    {
        return $this->traslado;
    }

    /**
     * Set condicion
     *
     * @param AppBundle\Entity\CondCurso $condicion
     * @return Matricula
     */
    public function setCondicion(\AppBundle\Entity\CondCurso $condicion = null)
    {
        $this->condicion = $condicion;
    
        return $this;
    }

    /**
     * Get condicion
     *
     * @return AppBundle\Entity\CondCurso 
     */
    public function getCondicion()
    {
        return $this->condicion;
    }

    /**
     * Set session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Matricula
     */
    public function setSession(\AppBundle\Entity\Sessiones $session = null)
    {
        $this->session = $session;
    
        return $this;
    }

    /**
     * Get session
     *
     * @return \AppBundle\Entity\Sessiones 
     */
    public function getSession()
    {
        return $this->session;
    }

    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     *
     * @return Matricula
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;

        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }
}
