<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * @ORM\Table(name="estudiante")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\EstudianteRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Estudiante implements UserInterface{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=30, unique=true)
     */
    protected $cedula;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $primer_nombre;
    
    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    protected $segundo_nombre;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $primer_apellido;
    
    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    protected $segundo_apellido;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $nacionalidad;
    
    /**
     * @ORM\Column(type="date")
     */
    protected $fecha_nacimiento;
        
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $sexo;
    
    /**
     * @ORM\Column(type="string", length=20)
     */
    protected $estado_civil;
    
    /**
     * @ORM\Column(type="text", nullable=true)
     */
    protected $direccion;

    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
     protected $condi_residencia;

     /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
     protected $priv_libertad;

     /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
     protected $plantel_graduado;

     /**
     * @ORM\Column(type="string", length=4, nullable=true)
     */
     protected $clasif_plantel;

     /**
     * @ORM\Column(type="date")
     */
     protected $fecha_graduado;

    /**
     * @ORM\Column(type="string", length=4, nullable=true)
     */
     protected $beca;
     
     /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
     protected $num_rusnies;

     /**
     * @ORM\Column(type="string", length=4, nullable=true)
     */
     protected $nivel_economico;
     
    /**
     * @ORM\Column(type="string", length=12, nullable=true)
     */
    protected $telefono_movil;
    
    /**
     * @ORM\Column(type="string", length=12, nullable=true)
     */
    protected $telefono_local;
    
    /**
     * @ORM\Column(type="string")
     */
    protected $email;
    
    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    protected $twitter;
    
       
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $salf;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     */
    protected $password;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="estudiante", cascade={"persist"})
     * @Assert\NotNull(message="Debe Agregar datos académicos")
     */
    protected $espeestud;
    
    /**
     * @ORM\ManyToOne(targetEntity="Pais", inversedBy="estudiante")
     * @ORM\JoinColumn(name="pais_id", referencedColumnName="id")
     */
    protected $pais;
    
    /**
     * @ORM\ManyToOne(targetEntity="Estados", inversedBy="estudiante")
     * @ORM\JoinColumn(name="estado_id", referencedColumnName="id")
     */
    protected $estado;
    
    /**
     * @ORM\ManyToOne(targetEntity="Ciudades", inversedBy="estudiante")
     * @ORM\JoinColumn(name="ciudad_id", referencedColumnName="id")
     */
    protected $ciudad; 
    
    /**
     * @ORM\ManyToOne(targetEntity="Municipios", inversedBy="estudiante")
     * @ORM\JoinColumn(name="municipio_id", referencedColumnName="id")
     */
    protected $municipio;
    
    /**
     * @ORM\ManyToOne(targetEntity="Etnia", inversedBy="estudiante")
     * @ORM\JoinColumn(name="etnia_id", referencedColumnName="id")
     */
    protected $etnia;
    
    /**
     * @ORM\ManyToOne(targetEntity="Discapacidades", inversedBy="estudiante")
     * @ORM\JoinColumn(name="discapacidad_id", referencedColumnName="id")
     */
    protected $discapacidad;
    

    /**
     * @ORM\OneToMany(targetEntity="Sessiones", mappedBy="usuario_alum")
     */
    protected $session;


    /**
     * @ORM\ManyToOne(targetEntity="TipoEstudiante", inversedBy="estudiante")
     * @ORM\JoinColumn(name="tiposestudiante_id", referencedColumnName="id")
     */
    protected $tipoestudiante;

    /**
     * @ORM\OneToMany(targetEntity="SubSede", mappedBy="estudiante")
     */
    protected $subsede;


   

    //-- METODOS GENERADOS PARA LAS CONSULTAS --------//
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set cedula
     *
     * @param string $cedula
     * @return Estudiante
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;
    
        return $this;
    }

    /**
     * Get cedula
     *
     * @return string 
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set primer_nombre
     *
     * @param string $primerNombre
     * @return Estudiante
     */
    public function setPrimerNombre($primerNombre)
    {
        $this->primer_nombre = $primerNombre;
    
        return $this;
    }

    /**
     * Get primer_nombre
     *
     * @return string 
     */
    public function getPrimerNombre()
    {
        return $this->primer_nombre;
    }

    /**
     * Set segundo_nombre
     *
     * @param string $segundoNombre
     * @return Estudiante
     */
    public function setSegundoNombre($segundoNombre)
    {
        $this->segundo_nombre = $segundoNombre;
    
        return $this;
    }

    /**
     * Get segundo_nombre
     *
     * @return string 
     */
    public function getSegundoNombre()
    {
        return $this->segundo_nombre;
    }

    /**
     * Set primer_apellido
     *
     * @param string $primerApellido
     * @return Estudiante
     */
    public function setPrimerApellido($primerApellido)
    {
        $this->primer_apellido = $primerApellido;
    
        return $this;
    }

    /**
     * Get primer_apellido
     *
     * @return string 
     */
    public function getPrimerApellido()
    {
        return $this->primer_apellido;
    }

    /**
     * Set segundo_apellido
     *
     * @param string $segundoApellido
     * @return Estudiante
     */
    public function setSegundoApellido($segundoApellido)
    {
        $this->segundo_apellido = $segundoApellido;
    
        return $this;
    }

    /**
     * Get segundo_apellido
     *
     * @return string 
     */
    public function getSegundoApellido()
    {
        return $this->segundo_apellido;
    }

    /**
     * Set nacionalidad
     *
     * @param string $nacionalidad
     * @return Estudiante
     */
    public function setNacionalidad($nacionalidad)
    {
        $this->nacionalidad = $nacionalidad;
    
        return $this;
    }

    /**
     * Get nacionalidad
     *
     * @return string 
     */
    public function getNacionalidad()
    {
        return $this->nacionalidad;
    }

    /**
     * Set fecha_nacimiento
     *
     * @param \DateTime $fechaNacimiento
     * @return Estudiante
     */
    public function setFechaNacimiento($fechaNacimiento)
    {
        $this->fecha_nacimiento = $fechaNacimiento;
    
        return $this;
    }

    /**
     * Get fecha_nacimiento
     *
     * @return \DateTime 
     */
    public function getFechaNacimiento()
    {
        return $this->fecha_nacimiento;
    }
    
     /**
     * Set sexo
     *
     * @param string $sexo
     * @return Estudiante
     */
    public function setSexo($sexo)
    {
        $this->sexo = $sexo;
    
        return $this;
    }

    /**
     * Get sexo
     *
     * @return string 
     */
    public function getSexo()
    {
        return $this->sexo;
    }

    /**
     * Set direccion
     *
     * @param string $direccion
     * @return Estudiante
     */
    public function setDireccion($direccion)
    {
        $this->direccion = $direccion;
    
        return $this;
    }

    /**
     * Get direccion
     *
     * @return string 
     */
    public function getDireccion()
    {
        return $this->direccion;
    }

    /**
     * Set condiresidencia
     *
     * @param string $condiresidencia
     * @return Estudiante
     */
     public function setCondiResidencia($condiresidencia)
     {
         $this->condi_residencia = $condiresidencia;
     
         return $this;
     }
 
     /**
      * Get condiresidencia
      *
      * @return string 
      */
     public function getCondiResidencia()
     {
         return $this->condi_residencia;
     }
    
    /**
     * Set privlibertad
     *
     * @param string $privlibertad
     * @return Estudiante
     */
     public function setPrivLibertad($privlibertad)
     {
         $this->priv_libertad = $privlibertad;
     
         return $this;
     }
 
     /**
      * Get privlibertad
      *
      * @return string 
      */
     public function getPrivLibertad()
     {
         return $this->priv_libertad;
     }
     
    /**
     * Set numrusnies
     *
     * @param string $numrusnies
     * @return Estudiante
     */
     public function setNumRusnies($numrusnies)
     {
         $this->num_rusnies = $numrusnies;
     
         return $this;
     }
 
     /**
      * Get numrusnies
      *
      * @return string 
      */
     public function getNumRusnies()
     {
         return $this->num_rusnies;
     }

    /**
     * Set fechagraduado
     *
     * @param \DateTime $fechagraduado
     * @return Estudiante
     */
      public function setFechaGraduado($fechagraduado)
      {
          $this->fecha_graduado = $fechagraduado;
      
          return $this;
      }
      
     /**
      * Get fechagraduado
      *
      * @return \DateTime 
      */
      public function getFechaGraduado()
      {
          return $this->fecha_graduado;
      }

    /**
     * Set clasifplantel
     *
     * @param string $clasifplantel
     * @return Estudiante
     */
     public function setClasifPlantel($clasifplantel)
     {
         $this->clasif_plantel = $clasifplantel;
     
         return $this;
     }

    /**
      * Get clasifplantel
      *
      * @return string 
      */
     public function getClasifPlantel()
     {
         return $this->clasif_plantel;
     }

    /**
     * Set beca
     *
     * @param string $beca
     * @return Estudiante
     */
     public function setBeca($beca)
     {
         $this->beca = $beca;
     
         return $this;
     }

    /**
      * Get beca
      *
      * @return string 
      */
     public function getBeca()
     {
         return $this->beca;
     }

    /**
     * Set niveleconomico
     *
     * @param string $niveleconomico
     * @return Estudiante
     */
     public function setNivelEconomico($niveleconomico)
     {
         $this->nivel_economico = $niveleconomico;
     
         return $this;
     }

    /**
      * Get niveleconomico
      *
      * @return string 
      */
     public function getNivelEconomico()
     {
         return $this->nivel_economico;
     }

    /**
     * Set plantelgraduado
     *
     * @param string $plantelgraduado
     * @return Estudiante
     */
     public function setPlantelGraduado($plantelgraduado)
     {
         $this->plantel_graduado = $plantelgraduado;
     
         return $this;
     }
 
     /**
      * Get plantelgraduado
      *
      * @return string 
      */
     public function getPlantelGraduado()
     {
         return $this->plantel_graduado;
     }


    /**
     * Set telefono_movil
     *
     * @param string $telefonoMovil
     * @return Estudiante
     */
    public function setTelefonoMovil($telefonoMovil)
    {
        $this->telefono_movil = $telefonoMovil;
    
        return $this;
    }

    /**
     * Get telefono_movil
     *
     * @return string 
     */
    public function getTelefonoMovil()
    {
        return $this->telefono_movil;
    }

    /**
     * Set telefono_local
     *
     * @param string $telefonoLocal
     * @return Estudiante
     */
    public function setTelefonoLocal($telefonoLocal)
    {
        $this->telefono_local = $telefonoLocal;
    
        return $this;
    }

    /**
     * Get telefono_local
     *
     * @return string 
     */
    public function getTelefonoLocal()
    {
        return $this->telefono_local;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Estudiante
     */
    public function setEmail($email)
    {
        $this->email = $email;
    
        return $this;
    }

    /**
     * Get email
     *
     * @return email 
     */
    public function getEmail()
    {
        return $this->email;
    }

    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    

    /**
     * Add espeestud
     *
     * @param AppBundle\Entity\EspeEstud $espeestud
     * @return Estudiante
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
        
    
        foreach ($espeestud as $esp) {
            $esp->setEstudiante($this);            
        }
        
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }
    
    // METODO PARA OBTENER INFORMACION
    public function __toString(){
        return $this->getPrimerNombre().' '.$this->getPrimerApellido();
    }

    /**
     * Set salf
     *
     * @param string $salf
     * @return Estudiante
     */
    public function setSalf($salf)
    {
        $this->salf = $salf;
    
        return $this;
    }

    /**
     * Get salf
     *
     * @return string 
     */
    public function getSalf()
    {
        return $this->salf;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Estudiante
     */
    public function setPassword($password)
    {
        $this->password = $password;
    
        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->password;
    }

    public function eraseCredentials() {
        
    }

    public function getRoles() {
         return array('ROLE_ESTUD');
    }

    public function getSalt() {
        
    }

    public function getUsername() {
        return $this->getPrimerNombre().' '.$this->getPrimerApellido();
    }
    
    public function equals(UserInterface $user){
        
    }

    /**
     * Set estado_civil
     *
     * @param string $estadoCivil
     * @return Estudiante
     */
    public function setEstadoCivil($estadoCivil)
    {
        $this->estado_civil = $estadoCivil;
    
        return $this;
    }

    /**
     * Get estado_civil
     *
     * @return string 
     */
    public function getEstadoCivil()
    {
        return $this->estado_civil;
    }

    /**
     * Add session
     *
     * @param \AppBundle\Entity\Sessiones $session
     * @return Estudiante
     */
    public function addSession(\AppBundle\Entity\Sessiones $session)
    {
        $this->session[] = $session;
    
        return $this;
    }

    /**
     * Remove session
     *
     * @param \AppBundle\Entity\Sessiones $session
     */
    public function removeSession(\AppBundle\Entity\Sessiones $session)
    {
        $this->session->removeElement($session);
    }

    /**
     * Get session
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Set pais
     *
     * @param \AppBundle\Entity\Pais $pais
     * @return Estudiante
     */
    public function setPais(\AppBundle\Entity\Pais $pais = null)
    {
        $this->pais = $pais;
    
        return $this;
    }

    /**
     * Get pais
     *
     * @return \AppBundle\Entity\Pais 
     */
    public function getPais()
    {
        return $this->pais;
    }

    /**
     * Set estado
     *
     * @param \AppBundle\Entity\Estados $estado
     * @return Estudiante
     */
    public function setEstado(\AppBundle\Entity\Estados $estado = null)
    {
        $this->estado = $estado;
    
        return $this;
    }

    /**
     * Get estado
     *
     * @return \AppBundle\Entity\Estados 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set ciudad
     *
     * @param \AppBundle\Entity\Ciudades $ciudad
     * @return Estudiante
     */
    public function setCiudad(\AppBundle\Entity\Ciudades $ciudad = null)
    {
        $this->ciudad = $ciudad;
    
        return $this;
    }

    /**
     * Get ciudad
     *
     * @return \AppBundle\Entity\Ciudades 
     */
    public function getCiudad()
    {
        return $this->ciudad;
    }

    /**
     * Set municipio
     *
     * @param \AppBundle\Entity\Municipios $municipio
     * @return Estudiante
     */
    public function setMunicipio(\AppBundle\Entity\Municipios $municipio = null)
    {
        $this->municipio = $municipio;
    
        return $this;
    }

    /**
     * Get municipio
     *
     * @return \AppBundle\Entity\Municipios 
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }

    /**
     * Set etnia
     *
     * @param \AppBundle\Entity\Etnia $etnia
     * @return Estudiante
     */
    public function setEtnia(\AppBundle\Entity\Etnia $etnia = null)
    {
        $this->etnia = $etnia;
    
        return $this;
    }

    /**
     * Get etnia
     *
     * @return \AppBundle\Entity\Etnia 
     */
    public function getEtnia()
    {
        return $this->etnia;
    }

    /**
     * Set discapacidad
     *
     * @param \AppBundle\Entity\Discapacidades $discapacidad
     * @return Estudiante
     */
    public function setDiscapacidad(\AppBundle\Entity\Discapacidades $discapacidad = null)
    {
        $this->discapacidad = $discapacidad;
    
        return $this;
    }

    /**
     * Get discapacidad
     *
     * @return \AppBundle\Entity\Discapacidades 
     */
    public function getDiscapacidad()
    {
        return $this->discapacidad;
    }

    /**
     * Set twitter
     *
     * @param string $twitter
     * @return Estudiante
     */
    public function setTwitter($twitter)
    {
        $this->twitter = $twitter;
    
        return $this;
    }

    /**
     * Get twitter
     *
     * @return string 
     */
    public function getTwitter()
    {
        return $this->twitter;
    }


    /**
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function setPersistValue()
    {
        foreach ($this->espeestud as $esp) {
            $esp->setEstudiante($this);
        }
    }

    /**
     * Set tipoestudiante
     *
     * @param \AppBundle\Entity\TipoEstudiante $tipoestudiante
     *
     * @return Estudiante
     */
    public function setTipoestudiante(\AppBundle\Entity\TipoEstudiante $tipoestudiante = null)
    {
        $this->tipoestudiante = $tipoestudiante;

        return $this;
    }

    /**
     * Get tipoestudiante
     *
     * @return \AppBundle\Entity\TipoEstudiante
     */
    public function getTipoestudiante()
    {
        return $this->tipoestudiante;
    }

    /**
     * Add subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return Estudiante
     */
    public function addSubsede(\AppBundle\Entity\SubSede $subsede)
    {
        $this->subsede[] = $subsede;

        return $this;
    }

    /**
     * Remove subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     */
    public function removeSubsede(\AppBundle\Entity\SubSede $subsede)
    {
        $this->subsede->removeElement($subsede);
    }

    /**
     * Get subsede
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
