<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="areas")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\AreasRepository")
 */
class Areas {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=50)
     */
    protected $descripcion;


    /**
     * @ORM\Column(type="boolean")
     */
    protected $vigente;

    /**
     * @ORM\OneToMany(targetEntity="Cursos", mappedBy="Areas")
     */
    protected $cursos;

    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cursos = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Areas
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     *
     * @return Areas
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Set vigente
     *
     * @param boolean $vigente
     *
     * @return Areas
     */
    public function setVigente($vigente)
    {
        $this->vigente = $vigente;

        return $this;
    }

    /**
     * Get vigente
     *
     * @return boolean
     */
    public function getVigente()
    {
        return $this->vigente;
    }

    /**
     * Add cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     *
     * @return Areas
     */
    public function addCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos[] = $cursos;

        return $this;
    }

    /**
     * Remove cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     */
    public function removeCursos(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos->removeElement($cursos);
    }

    /**
     * Get cursos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCursos()
    {
        return $this->cursos;
    }

    public function __toString()
    {
        return $this->descripcion;
    }

    /**
     * Add curso
     *
     * @param \AppBundle\Entity\Cursos $curso
     *
     * @return Areas
     */
    public function addCurso(\AppBundle\Entity\Cursos $curso)
    {
        $this->cursos[] = $curso;

        return $this;
    }

    /**
     * Remove curso
     *
     * @param \AppBundle\Entity\Cursos $curso
     */
    public function removeCurso(\AppBundle\Entity\Cursos $curso)
    {
        $this->cursos->removeElement($curso);
    }
}
