<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Form\UsuariosType;  
use AppBundle\Entity\Usuarios;

use AppBundle\Entity\SubSede;
use AppBundle\Entity\Sede;

use AppBundle\Entity\SubSedeUsuario;


use Doctrine\ORM\EntityRepository;

/**
 * Description of SubSedeUsuario
 *
 * @author josemorlet
 */
class SubSedeUsuarioController extends Controller {
    
    /**
     * @Route("/app/admin/subsede/usuarios", name="app_subsedeusuarios_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:SubSedeUsuario')->findAll();
        
        
        
        return $this->render('AppBundle:SubSedeUsuario:index.html.twig', array(
            'entities' => $entities
        ));
        
        
    }
    
    /**
     * @Route("/app/admin/subsede/usuarios/consultsubsede", name="app_subsedeusuarios_search", requirements={"_method":"POST"})
     */
     public function consultMenuUsuarioAction()
    {
        $request = $this->getRequest();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getManager();
        $cedula = $request->get('cedulausu');
        $usuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
        $users = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedula)); 
          
            $menugen = $em->getRepository('AppBundle:SubSedeUsuario')->consultSubSedeGen();     
            $menusu = $em->getRepository('AppBundle:SubSedeUsuario')->consultSubSedeUsu($usuario->getId()); 
            
            return $this->render('AppBundle:SubSedeUsuario:result.html.twig', array(
            'menug'=>$menugen, 'menuusu'=>$menusu, 'idusu'=>$usuario->getId(), 'usuario'=>$usuario, 'users'=>$users,
        ));      
    }
 
    /**
     * @Route("/app/admin/subsede/usuarios/editsubsede", name="app_subsedeusuarios_edit", requirements={"_method":"POST"})
     */
    public function editMenuUsuarioAction()
    {
        $request = $this->getRequest();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $id = $request->get('id');
        $item = $request->get('item');
        $exit = $em->getRepository('AppBundle:SubSedeUsuario')->findOneBy(array('usuario'=>$id, 'subsede'=>$item));
        if($exit){
            $em->remove($exit); 
        }else{
            $menu = new SubSedeUsuario();
            $usuario = $em->getRepository('AppBundle:Usuarios')->find($id);
            $items = $em->getRepository('AppBundle:SubSede')->find($item);
            $menu->setUsuario($usuario);
            $menu->setSubsede($items);
            $em->persist($menu);
        }
        $em->flush();
        
        $menugen = $em->getRepository('AppBundle:SubSedeUsuario')->consultSubSedeGen(); 
        $menusu = $em->getRepository('AppBundle:SubSedeUsuario')->consultSubSedeUsu($id);
        return $this->render('AppBundle:SubSedeUsuario:result.html.twig', array(
            'menug'=>$menugen, 'menuusu'=>$menusu, 'idusu'=>$id,
        ));
    }

}
