<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Matricula;
use AppBundle\Form\MatriculaType;

/**
 * Description of MatriculaController
 *
 * @author jose
 */
class MatriculaController extends Controller {
    

    
    
    
    /**
     * @Route("/app/admin/edit/matricula/{id}", name="app_admin_matricula_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Matricula')->find($id);        
        $form = $this->editForm($entity,$em);
        
        return $this->render('AppBundle:Profesores:editmatricula.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/matricula/{id}", name="app_admin_matricula_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {

        $reqMatricula = $request->get('matricula');
 $reqNotas= $request->get('notas');
      //  $reqStatus= $request->get('status');
     

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Matricula')->find($id);        
        $form = $this->editForm($entity,$em);
        
        $form->handleRequest($request);
        
       
        
            
            //ACTUALIZAR HIST_MATRI
            $histExist = $em->getRepository('AppBundle:HistMatri')->findOneByMatricula($entity->getId());
                   if(!$histExist)
        {

            $newHistMatri = new \AppBundle\Entity\HistMatri();
                $newHistMatri->setMatricula($entity);
                $newHistMatri->setCondicion($entity->getCondicion());
                $newHistMatri->setCurso($entity->getOferta()->getCurso());
                $newHistMatri->setEspecialidad($entity->getEstudiante()->getEspecialidad());
                $newHistMatri->setEstudiante($entity->getEstudiante());
                $newHistMatri->setLapso($entity->getOferta()->getLapso());
                $newHistMatri->setNota($entity->getNota());
                $newHistMatri->setObs('Pasado Matricula '.$entity->getOferta()->getLapso()->getCodigo());
                $newHistMatri->setPrograma($entity->getOferta()->getPrograma());
                $newHistMatri->setSede($entity->getOferta()->getSede());
                $newHistMatri->setUc($entity->getOferta()->getCurso()->getUc());
                $newHistMatri->setSeccion($entity->getOferta()->getSeccion());
                $em->persist($newHistMatri);
          
        
            }else{
                $histExist->setMatricula($entity);
                $histExist->setCondicion($entity->getCondicion());
                $histExist->setCurso($entity->getOferta()->getCurso());
                $histExist->setEspecialidad($entity->getEstudiante()->getEspecialidad());
                $histExist->setEstudiante($entity->getEstudiante());
                $histExist->setLapso($entity->getOferta()->getLapso());
                $histExist->setNota($entity->getNota());
                $histExist->setObs('Pasado Matricula '.$entity->getOferta()->getLapso()->getCodigo());
                $histExist->setPrograma($entity->getOferta()->getPrograma());
                $histExist->setSede($entity->getOferta()->getSede());
                $histExist->setUc($entity->getOferta()->getCurso()->getUc());
                $histExist->setSeccion($entity->getOferta()->getSeccion());
                $em->persist($histExist);
            }



  //ACTUALIZAR Auditoria
                $ids = $this->getUser()->getId();
                $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids); 
                $auditoria = $em->getRepository('AppBundle:Auditoria')->findOneByMatricula($entity->getId());
                   if(!$auditoria)
            {

            $newAuditoria = new \AppBundle\Entity\Auditoria();
                $newAuditoria->setMatricula($entity);
                $newAuditoria->setCondicion($entity->getCondicion());
                $newAuditoria->setCurso($entity->getOferta()->getCurso());
                $newAuditoria->setEspecialidad($entity->getEstudiante()->getEspecialidad());
                $newAuditoria->setUsuario($usuarios);
                $newAuditoria->setEstudiante($entity->getEstudiante());
                $newAuditoria->setLapso($entity->getOferta()->getLapso());
                $newAuditoria->setNota($entity->getNota());
                $newAuditoria->setProceso('Proceso Modificacion ');
                $newAuditoria->setPrograma($entity->getOferta()->getPrograma());
                $newAuditoria->setSede($entity->getOferta()->getSede());
                $newAuditoria->setFechaHora(new \DateTime("now"));
                $newAuditoria->setSeccion($entity->getOferta()->getSeccion());
                $em->persist($newAuditoria);
          
        
            }else{
                $auditoria->setMatricula($entity);
                $auditoria->setCondicion($entity->getCondicion());
                $auditoria->setCurso($entity->getOferta()->getCurso());
                $auditoria->setEspecialidad($entity->getEstudiante()->getEspecialidad());
                $auditoria->setUsuario($usuarios);
                $auditoria->setEstudiante($entity->getEstudiante());
                $auditoria->setLapso($entity->getOferta()->getLapso());
                $auditoria->setNota($entity->getNota());
                $auditoria->setProceso('Proceso Modificacion ');
                $auditoria->setPrograma($entity->getOferta()->getPrograma());
                $auditoria->setSede($entity->getOferta()->getSede());
                $auditoria->setFechaHora(new \DateTime("now"));
                $auditoria->setSeccion($entity->getOferta()->getSeccion());
                $em->persist($auditoria);
            }
        












        if($form->isValid())
                 {
                     






























            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
           
        }
        
        return $this->render('AppBundle:Profesores:editmatricula.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Matricula $entity , \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new MatriculaType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_matricula_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
  
    
}