<?php
namespace AppBundle\Controller;


use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Matricula;
use AppBundle\Entity\EspeEstud;
use AppBundle\Entity\OfertAcade;
use AppBundle\Utils\ReporteLayout;
/**
 * Description of InscripcionController
 *
 * @author jose
 */
class InscripcionController extends Controller {
    //put your code here
    
    /**
     * @Route("/app/admin/consult/estud/inscripcion", name="app_admin_consul_estud_inscripcion")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Inscripcion:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }    
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_result_estud_inscripcion'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/result/estud/inscripcion", name="app_admin_result_estud_inscripcion", requirements={"_method":"GET"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();

        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = '';
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);

            $lapsos= $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);

            if(!$lapsos){
                $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO DE INSCRIPCIÓN CERRADO');
                return $this->redirect($this->generateUrl('app_admin_result_estud_inscripcion'));
            }
            
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_result_estud_inscripcion'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('estudiante'=>$estudiante->getId()));

            $codact = $em->getRepository('AppBundle:EspeEstud')->findOneByActivo($estudiante->getId());

            foreach ($codact as $value ){
                if($value->getActivo() == 1){
                    $activo = $value->getActivo();
                }
            }

            if(!$activo){
            $this->get('session')->getFlashBag()->add('msg-error',$estudiante->getId().' Estudiante Inactivo');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }
            
            return $this->render('AppBundle:Inscripcion:result.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Inscripcion:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/inscripcion/", name="app_admin_estudiante_inscripcion")
     */
    public function inscripcionEstudianteAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);

        foreach ($activo as $act){

            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);

            $especialidad = $request->get('especialidad');
            $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
            $subsede = $espeestud->getSubsede();
           
            $programa = $espeestud->getPrograma();
            $cohorteespe = $espeestud->getCohorte()->getId();
            $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
            $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoI($fechanow);
                
        
            if(!$procesos){
                $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
                return $this->redirect($request->headers->get('referer'));
            }
            
            $depositado = $em->getRepository('AppBundle:Depositos')->findTotalDepositado($especialidad, $lapsoac->getId());
            $exoneracion = $em->getRepository('AppBundle:Exonerados')->getExeracionEstudiante($espeestud, $lapsoac);
            $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew2($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad, $subsede);
            $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
           //$cursosAsesorados = $em->getRepository('AppBundle:Asesoria')->findCursoAsesoradoEstudiante($especialidad, $lapsoac->getId());
            
            $montoInscrito = $em->getRepository('AppBundle:Matricula')->getMontoInscritoEstudiante($cursosInscritos, $em, $configPrograma);
        }
        
        $this->get('session')->set('config_act', array('configPrograma'=>$configPrograma, 'depositado'=>$depositado['depositado'],'montoInscrito'=>$montoInscrito, 'cursosInscritos'=>$cursosInscritos,'exonerado'=>$exoneracion));
        return $this->render('AppBundle:Inscripcion:inscripcion.html.twig', array(
            'cursos'=>$cursosOfertados,
            'config'=>$configPrograma,            
            'cursosInscritos'=>$cursosInscritos,
            'especialidad'=>$especialidad,
            'lapsoc'=>$lapso,
            'cohorteespe'=> $espeestud->getCohorte()->getCodigo(),
            'depositado'=>$depositado,
            'montoInscrito'=>$montoInscrito,
            'espe_estud'=>$espeestud
        ));    
    }
    
    /**
     * @Route("/app/admin/estudiantes/process/inscripcion/{especialidad}/{lapso}", name="app_admin_estudiante_process_inscripcion")
     */
    public function processInscripcionEstudianteAction($especialidad,$lapso, Request $request)
    {
        $cursosAInscri = json_decode($request->get('cursos'), true);
        $indexes = $request->get('indexes');
        $id = explode(',', $indexes);
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $config = $this->get('session')->get('config_act');
        $depositado = $config['depositado'];
        $montoInscripcion = $config['montoInscrito'];        
        $horarios = array();
        //echo $indexes;
        //var_dump($id);
        //var_dump($cursosAInscri);
        for($i = 0 ; $i < count($id); $i++)
        {
            
            $idofert = $cursosAInscri[$id[$i]]['oferta'];
            $idhorario = $cursosAInscri[$id[$i]]['horario'];            
            
            $horarios[$idofert]=array('oferta'=>$idofert, 'horario'=>$idhorario);
            $ofert = $em->getRepository('AppBundle:OfertAcade')->find($idofert); 
            $alumnos = $ofert->getCantidadAlumnos();
            $cupos = $ofert->getCantidadCupos();
            $montoInscripcion += $em->getRepository('AppBundle:Matricula')->getMontoUc($em, $ofert, $config['configPrograma']);
            
            if( $alumnos < $cupos ){                
                $matriculaExist = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudianteLapso($especialidad, $lapso, $ofert->getCurso()->getId());
                
                if(!$matriculaExist){
                    
                    $matricula = new Matricula();                    
                    $condicion = $em->getRepository('AppBundle:CondCurso')->findOneBy(array('nombre'=>'INSCRITO'));
                    $matricula->setOferta($ofert);
                    $matricula->setCondicion($condicion);
                    $matricula->setEstudiante($estudiante);
                    $em->persist($matricula);    
                    
                    
                }else{
                    $this->get('session')->getFlashBag()->add('msg-error', 'Curso señalado ya esta inscrito!');
                    $data['resp'] = true;        
                    $response[] = $data;
                    $respuesta = new Response(json_encode($response));
                    $respuesta->headers->set('Content-Type', 'application/json');
                    return $respuesta;
                }
            }else{
                $this->get('session')->getFlashBag()->add('msg-error', 'Curso señalado no tiene cupos disponibles');
                $data['resp'] = true;        
                $response[] = $data;
                $respuesta = new Response(json_encode($response));
                $respuesta->headers->set('Content-Type', 'application/json');
                return $respuesta;
            }
        }
        if(!$config['configPrograma']->getControlPago()){
            $sobrePasa = ($montoInscripcion<=$depositado)? 1 : 0;   
        }else{
            $sobrePasa = 1;
        }
        if(!$sobrePasa) {$this->get('session')->getFlashBag()->add('msg-error', 'El monto depositado es insuficiente para realizar la inscripción!');}        
        
        if($config['configPrograma']->getChoque()){
            $choque = $em->getRepository('AppBundle:OfertAcade')->choqueHorario($horarios, $config['cursosInscritos']);
        }else{
            $choque = 1;
        }
        
        if(!$choque){
            $this->get('session')->getFlashBag()->add('msg-error', 'Existe un choque de horario en los cursos señalados');
            $data['resp'] = true;        
            $response[] = $data;
            $respuesta = new Response(json_encode($response));
            $respuesta->headers->set('Content-Type', 'application/json');
            return $respuesta;
        }
        if($sobrePasa && $choque){
                $em->flush();
                foreach ($horarios as $o)
                {
                    $em->getRepository('AppBundle:OfertAcade')->updateOfertaMasUn($o['oferta']);
                }
                $this->get('session')->getFlashBag()->add('msg-success', 'Inscripción realizada con exito!');
        }        
        
        $data['resp'] = true;        
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
        
    /**
     * @Route("/app/admin/estudiantes/record/academico/{id}", name="app_admin_estudiante_record_academico")
     */
    public function reportRecordAcademicoAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
     
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $entities = $em->getRepository('AppBundle:EspeEstud')->findHistMatri($espe_estud);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(15,25,85,10,10,20,25));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Record Académico');
        $pdf->aligns = array('C','C', 'L', 'C', 'C', 'C', 'L');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Lapso', 'Código', 'Nombre del Curso', 'UC', 'Cal', 'UC*Cal', 'Condición');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $puntos = 0;
        $indiceac = 0;
        foreach ($entities as $value){
                 
            if($value->getCurso()->getPlanestudio()[0]->getComponentes()->getDescripcion()=='TRABAJO DE GRADO'){
                $nota = '';
                $uc = 0;
                $ucxnota = '';
            }else{
                 $nota = $value->getNota();
                 $uc = $value->getCurso()->getUc();
                 $ucxnota = $nota * $uc;
                 $puntos += $ucxnota;
                 $indiceac += $uc;
             }
            $pdf->RowBorders(array($value->getLapso()->getCodigo(),
                                   $value->getCurso()->getCodigo(),
                                   $value->getCurso()->getNombre(),
                                   $uc,
                                   $nota,
                                   $ucxnota,
                                   $value->getCondicion()->getNombre(),
                            ), 0);
        }  
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(63,10,'Puntos: '.  number_format($puntos, 2, ',','.'),'T',0,'C');
        $pdf->Cell(64,10,'UC indice: '.$indiceac,'T',0,'C');
        $pdf->Cell(63,10,'IND*ACAD: '.@number_format($puntos/$indiceac,2,',','.'),'T',1,'C');
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $text1 = "UC= Unid. de Credito, IA= Indice Acad.(PTOS/UC), PTOS= Puntos(Suma de UC x C), C=Calificacion, CM= Cond. de Asig.; 3= Equiivalencia, 4= DOC. NoTrans.calf.,
6= Nota en Observa.,7= Prueba Extraor., 8= Sin Nota., 9= Inasistente.CM= 3,4,6,8 y 9 no afectan el Indice";
        $pdf->MultiCell(190, 3, $text1,0,'J');
        $text2 = "INDICE ACADEMICO CALCULADO SEGUN RESOLUCION No.2008.316.2818 EXAMINADA DEL CONSEJO UNIVERSIATRIO FECHA: 23 JULIO DE2008";
        $pdf->MultiCell(190, 3, $text2,0,'J');
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Listado de clases.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    /**
     * @Route("/app/admin/estudiantes/planilla/inscripcion/{id}", name="app_admin_estudiantes_planilla_inscripcion")
     */
    public function reportPlanillaInscripcionAction(Request $request, $id){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapso = $em->getRepository('AppBundle:Lapso')->find($this->get('session')->get('lapsoActual')->getId());
        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($espe_estud, $lapso);
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();         
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(25,75,10,15,10,55));
        //srand(microtime()*1000000);        
        $headerPage = array('Nombre y Apellido'=>$espe_estud->getEstudiante(), 
                        'Cédula'=>$espe_estud->getEstudiante()->getCedula(),
                        'Especialidad'=>$espe_estud->getEspecialidad()->getNombre(),
                        );
        $pdf->headerPageInfo($headerPage, 'B');
        
        $pdf->titleReport('Planilla de Inscripción - '.$lapso->getCodigo());
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Nombre del Curso', 'UC', 'Sección', 'Grupo', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                   $value->getOferta()->getGrupo(),
                                   $value->getOferta()->getHorario()
                            ), 0);
        }
         $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,'Total UC: ','T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        
        $pdf->Ln(5);
        $pdf->SetFont('helvetica','',7);
        
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(25);
        $pdf->Cell(63,10,'',0,0,'C');
        $pdf->Cell(64,10,  utf8_decode('Jefe de la Sección de Control de Estudios'),'T',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }

// Retido de cursos

    /**
     * @Route("/app/admin/consult/estud/retiro", name="app_admin_consul_estud_retiro")
     */
    public function indexRAction()
    {
        $form = $this->formSearchEstudianteR();
        return $this->render('AppBundle:Retiro:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchEstudianteR()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_result_estud_retiro'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/result/estud/retiro", name="app_admin_result_estud_retiro", requirements={"_method":"GET"})
     */
    public function searchEstudiantesRAction(Request $request)
    {
        $form = $this->formSearchEstudianteR();

        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = '';
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);

            $lapsos= $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);

            if(!$lapsos){
                $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO DE RETIRO CERRADO');
                return $this->redirect($this->generateUrl('app_admin_result_estud_retiro'));
            }
            
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_result_estud_retiro'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('estudiante'=>$estudiante->getId()));

            $codact = $em->getRepository('AppBundle:EspeEstud')->findOneByActivo($estudiante->getId());

            foreach ($codact as $value ){
                if($value->getActivo() == 1){
                    $activo = $value->getActivo();
                }
            }

            if(!$activo){
            $this->get('session')->getFlashBag()->add('msg-error',$estudiante->getId().' Estudiante Inactivo');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }
            
            return $this->render('AppBundle:Retiro:result.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Retiro:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    /**
     * @Route("/app/admin/retiro/", name="app_admin_estudiante_retiro")
     */
    public function retiroEstudianteAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);

        foreach ($activo as $act){

            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);

            $especialidad = $request->get('especialidad');
            $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
            $subsede = $espeestud->getSubsede();
           
            $programa = $espeestud->getPrograma();
            $cohorteespe = $espeestud->getCohorte()->getId();
            $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
            $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);
                
        
            if(!$procesos){
                $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
                return $this->redirect($request->headers->get('referer'));
            }
            
            $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew2($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad, $subsede);
            $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
        }
        
        return $this->render('AppBundle:Retiro:retiro.html.twig', array(
            'cursos'=>$cursosOfertados,          
            'cursosInscritos'=>$cursosInscritos,
            'especialidad'=>$especialidad,
            'lapsoc'=>$lapso,
            'cohorteespe'=> $espeestud->getCohorte()->getCodigo(),
            'espe_estud'=>$espeestud
        ));    
    }

    /**
     * @Route("/app/admin/estudiantes/delete/retiro/{especialidad}/{oferta}", name="app_admin_estudiante_delete_inscripcion")
     */
    public function deleteInscripcionEstudianteAction($especialidad, $oferta) {

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);
        $ofertAca = $em->getRepository('AppBundle:OfertAcade')->find($oferta);
        $cedula = $this->getUser()->getCedula();
        $ids = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
        $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids);
        $lapsoac = "";
        
        foreach ($activo as $act){
            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);
        }

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $matricula = $em->getRepository('AppBundle:Matricula')->findOneBy(array('estudiante'=>$especialidad, 'oferta'=>$oferta));
        $em->remove($matricula);
        $em->getRepository('AppBundle:OfertAcade')->updateOfertaMenosUn($oferta);

        $newAuditoria = new \AppBundle\Entity\AuditoriaRetiro();                      
        $newAuditoria->setEstudiante($estudiante);
        $newAuditoria->setLapso($lapsoac);
        $newAuditoria->setCurso($ofertAca->getCurso());
        $newAuditoria->setUsuarios($usuarios);
        $newAuditoria->setFechaHora(new \DateTime());
        $newAuditoria->setTipo("RETIRO DE UNIDAD/EJE CURRICULAR");

        $em->persist($newAuditoria);

        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'SE ELIMINO CON EXITO!');
        
        $data['resp'] = true;
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }

    /**
     * @Route("/app/admin/retiro/planilla/inscripcion/{id}", name="app_admin_retiro_planilla_inscripcion")
     */
    public function retiroPlanillaInscripcionAction($id,Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);
        $lapsoac = "";

            foreach ($activo as $act){
                $lapso = $act->getLapso()->getId();
                $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);
            }    

        $espe_estud = $em->getRepository('AppBundle:EspeEstud')->find($id);

        $entities = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudianteReport($espe_estud, $lapsoac);
        if(!$entities){
            $this->get('session')->getFlashBag()->add('msg-success', 'NO POSEE UNIDAD/EJE CURRICULAR PARA ESTE PERÍODO!');
            return $this->redirect($request->headers->get('referer'));
        }
        
        $pdf = new ReporteLayout();
        $pdf->setContainer($this->container);
        $pdf->AddPage();  
        $pdf->setSede($espe_estud->getSede());       
        //$pdf->Cell(40,10,'Hello World!');
        $pdf->SetWidths(array(20,77,8,15,70));

        $pdf->SetY(35);
        $pdf->titleReport('Planilla de Inscripción - '.$lapsoac->getCodigo());

        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(10,10,utf8_decode('Sede: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(105,10,utf8_decode(''.$espe_estud->getSede()->getNombre()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(13,10,utf8_decode('Cédula: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(57,10,utf8_decode(''.$espe_estud->getEstudiante()->getCedula()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(30,10,utf8_decode('Nombre y Apellido: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(37,10,utf8_decode(''.$espe_estud->getEstudiante()),0,'L');
            $pdf->Ln(4);
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(21,10,utf8_decode('Especialidad: '),0,'L');
        $pdf->SetFont('helvetica','',9);
        $pdf->Cell(118,10,utf8_decode(''.$espe_estud->getEspecialidad()->getNombre()),0,'L');
            $pdf->Ln(10);
        
        $pdf->aligns = array('C', 'L', 'C', 'C', 'C', 'C');
        
        $pdf->SetFont('helvetica','',9);
        $titles = array('Código', 'Unidad Curricular', 'C.A', 'Sección', 'Horario');
        $pdf->RowTitles($titles);
        $pdf->SetFont('helvetica','',8);
        $ucs = 0;
        
        foreach ($entities as $value){
            $ucs+=$value->getOferta()->getCurso()->getUc();
            $pdf->RowBorders(array($value->getOferta()->getCurso()->getCodigo(),
                                   $value->getOferta()->getCurso()->getNombre(),
                                   $value->getOferta()->getCurso()->getUc(),
                                   $value->getOferta()->getSeccion(),
                                   $value->getOferta()->getHorario() 
                            ), 0);
        }
       
        $pdf->SetFont('helvetica','B',9);
        $pdf->Cell(100, 6,utf8_decode('Total Créditos Académicos: '),'T',0,'R');
        $pdf->Cell(10, 6,$ucs,'T',0,'C');
        $pdf->Cell(80, 6,'','T',1,'L');
        $pdf->SetFont('helvetica','B',9);
        $pdf->Ln(5);
        $pdf->Ln(90);
        $pdf->SetFont('helvetica','',8);
    $pdf->Cell(0,10,  utf8_decode('- Control de Estudios se reserva el derecho de modificar y eliminar la planilla de Inscripción Nacional cuando se detecten aspectos que no proceden.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
    $pdf->Ln(3);
    $pdf->Cell(0,10,  utf8_decode('- Para ser válida la inscripción debe consignarse este documento ante Control de Estudios.'),'',0,'L');
        $pdf->SetFont('helvetica','',8);
    $pdf->Ln(3);
    $pdf->Cell(0,10,  utf8_decode('- Se considera como válida la última planilla de inscripción que emita el sistema.'),'',0,'L');
        $pdf->Ln(10);
        $pdf->SetFont('helvetica','',7);
        $pdf->Cell(64,10,  utf8_decode('ESTUDIANTE'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('SELLO'),'',0,'C');
        $pdf->Cell(64,10,  utf8_decode('CONTROL DE ESTUDIOS'),'',0,'C');
        $pdf->Cell(63,10,'',0,1,'C');
        
        
        
//        
//        $pdf->SetFont('helvetica','B',9);
//        $pdf->Cell('190', 6,'Total estudiantes: '.count($entities), 'T',1,'R');
        
        $pdf->Output('','Planilla de Inscricipcion.pdf', 1);
        
        return $this->dispositionReporte($pdf->Output());
    }
    
    /**
     * @Route("/app/admin/consult/estud/retiro/periodo", name="app_admin_estud_retiro_periodo")
     */
    public function indexRPAAction()
    {
        $form = $this->formSearchEstudianteRPA();
        return $this->render('AppBundle:Retiro:index_rpa.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchEstudianteRPA()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_result_estud_retiro_periodo'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/result/estud/retiro/periodo", name="app_admin_result_estud_retiro_periodo", requirements={"_method":"GET"})
     */
    public function searchEstudiantesRPAAction(Request $request)
    {
        $form = $this->formSearchEstudianteRPA();

        $fecha = new \DateTime();
        $fechanow = $fecha->format('Y-m-d');
        $activo = '';
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);

            $lapsos= $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);

            if(!$lapsos){
                $this->get('session')->getFlashBag()->add('msg-error', 'PROCESO DE RETIRO CERRADO');
                return $this->redirect($this->generateUrl('app_admin_result_estud_retiro_periodo'));
            }
            
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_result_estud_retiro_periodo'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('estudiante'=>$estudiante->getId()));

            $codact = $em->getRepository('AppBundle:EspeEstud')->findOneByActivo($estudiante->getId());

            foreach ($codact as $value ){
                if($value->getActivo() == 1){
                    $activo = $value->getActivo();
                }
            }

            if(!$activo){
            $this->get('session')->getFlashBag()->add('msg-error',$estudiante->getId().' Estudiante Inactivo');
                return $this->redirect($this->generateUrl('app_admin_result_estud_asesoria'));
            }
            
            return $this->render('AppBundle:Retiro:result_rpa.html.twig', array(
                'datos'=>$estudiante,
                'lapsos'=>$lapsos
            ));
        }
        
        return $this->render('AppBundle:Retiro:index_rpa.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    /**
     * @Route("/app/admin/retiro/periodo", name="app_admin_estudiante_retiro_periodo")
     */
    public function retiroPAEstudianteAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fechanow = new \DateTime();
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);

        foreach ($activo as $act){

            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);

            $especialidad = $request->get('especialidad');
            $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($especialidad);
            $subsede = $espeestud->getSubsede();
            $this->get('session')->set('estudiante', $especialidad);
           
            $programa = $espeestud->getPrograma();
            $cohorteespe = $espeestud->getCohorte()->getId();
            $configPrograma = $em->getRepository('AppBundle:ConfigSistema')->findOneBy(array('programa'=>$programa->getId()));                
            $procesos = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);
                
        
            if(!$procesos){
                $this->get('session')->getFlashBag()->add('msg-error', 'Proceso cerrado para la fecha actual');
                return $this->redirect($request->headers->get('referer'));
            }
            
            $cursosOfertados = $em->getRepository('AppBundle:OfertAcade')->findCursoOfertadoNew2($espeestud->getEspecialidad()->getId(), $lapsoac->getId(), 0, $especialidad, $subsede);
            $cursosInscritos = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudiante($especialidad, $lapsoac->getId());
        }
        
        return $this->render('AppBundle:Retiro:retiro_rpa.html.twig', array(
            'cursos'=>$cursosOfertados,          
            'cursosInscritos'=>$cursosInscritos,
            'especialidad'=>$especialidad,
            'lapsoc'=>$lapsoac,
            'cohorteespe'=> $espeestud->getCohorte()->getCodigo(),
            'espe_estud'=>$espeestud
        ));    
    }

    /**
     * @Route("/app/admin/estudiantes/delete/retiro/periodo", name="app_admin_estudiante_delete_retiro_periodo")
     */
    public function deleteRetiroPAEstudianteAction()
    {
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $fechanow = new \DateTime();
        $activo = $em->getRepository('AppBundle:Procesos')->findProcesoR($fechanow);
        $cedula = $this->getUser()->getCedula();
        $ids = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
        $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids);
        $espe_estud = $this->get('session')->get('estudiante');
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($espe_estud);
        $lapsoac = "";
        $oferta = "";
        
        foreach ($activo as $act){
            $lapso = $act->getLapso()->getId();
            $lapsoac = $em->getRepository('AppBundle:Lapso')->find($lapso);
        }

        $cursosInsc = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudianteRetiro($espe_estud);


        foreach ($cursosInsc as $value){

            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $oferta = $em->getRepository('AppBundle:OfertAcade')->find($value->getOferta()->getId());
            $matricula = $em->getRepository('AppBundle:Matricula')->findOneBy(array('estudiante'=>$espe_estud, 'oferta'=>$value->getOferta()->getId()));

            $em->remove($matricula);
            $em->getRepository('AppBundle:OfertAcade')->updateOfertaMenosUn($oferta);

            $newAuditoria = new \AppBundle\Entity\AuditoriaRetiro();                      
            $newAuditoria->setEstudiante($estudiante);
            $newAuditoria->setLapso($lapsoac);
            $newAuditoria->setCurso($oferta->getCurso());
            $newAuditoria->setUsuarios($usuarios);
            $newAuditoria->setFechaHora(new \DateTime());
            $newAuditoria->setTipo("RETIRO DE PERÍODO ACADÉMICO");

            $em->persist($newAuditoria);

            $em->flush();
            
        }

        $this->get('session')->getFlashBag()->add('msg-success',$matricula->getId() . 'SE RETIRO EL PERÍODO ACADÉMICO CON EXITO!');
        return $this->redirect($this->generateUrl('app_admin_result_estud_retiro_periodo'));
        
        $data['resp'] = true;
        $response[] = $data;
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }


}
