<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Exonerados;
use AppBundle\Form\ExoneradosType;

/**
 * Description of ExoneracionController
 *
 * @author jose
 */
class ExoneracionController extends Controller {
    
    /**
     * @Route("/app/admin/exoneracion", name="app_admin_alumn_exoneracion")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Exoneracion:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }    
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_admin_alumn_exoneracion_search'))
                ->setMethod('GET')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/exoneracion/search/estudiante", name="app_admin_alumn_exoneracion_search", requirements={"_method":"GET"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_admin_alumn_exoneracion'));
            }
            
            return $this->render('AppBundle:Exoneracion:result.html.twig', array(
                'datos'=>$estudiante
            ));
        }
        
        return $this->render('AppBundle:Exoneracion:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/exoneracion/show", name="app_admin_show_exoneracion_alum")
     */
    public function showExoneracionAction(Request $request)
    {
        $id = $request->get('id');        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $lapsoActual = $em->getRepository('AppBundle:Lapso')->findOneBy(array('activo'=>1));
        $exoneracion = $em->getRepository('AppBundle:Exonerados')->getExeracionEstudiante($estudiante, $lapsoActual);
                
        $entity = new Exonerados();
        $form = $this->formExoneracion($entity, $em, $id);
        
        return $this->render('AppBundle:Exoneracion:show.html.twig', array(
            'form'=>$form->createView(), 
            'exoneracion'=>$exoneracion,
        ));
    }
    
    /**
     * @Route("/app/admin/exoneracion/save/{id}", name="app_admin_save_exoneracion_alum")
     */
    public function saveExoneracionAction(Request $request, $id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $entity = new Exonerados();
        $form = $this->formExoneracion($entity, $em, $id);
        
        $form->handleRequest($request);
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($id);
        
        $existE = $em->getRepository('AppBundle:Exonerados')->getExeracionEstudiante($estudiante, $form['lapso']->getData());
        if(!$existE){
            if($form->isValid())
            {

                $entity->setEspecialidadEstudiante($estudiante);
                $entity->setFechainclucion(new \DateTime());
                $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($this->getUser()->getSede()->getCodigo());
                $em->persist($entity);
                $em->flush();
                $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado con exito!');
                return $this->forward('AppBundle:Exoneracion:showExoneracion', array('id'=>$id));
            }
            
        }else
        {
            $this->get('session')->getFlashBag()->add('msg-error', 'Estudiante ya tiene exoneración para el lapso señalado!');
            return $this->forward('AppBundle:Exoneracion:showExoneracion', array('id'=>$id));
        }
        
        $lapsoActual = $em->getRepository('AppBundle:Lapso')->findOneBy(array('activo'=>1));
        $exoneracion = $em->getRepository('AppBundle:Exonerados')->getExeracionEstudiante($estudiante, $lapsoActual);
        
        
        
        
        return $this->render('AppBundle:Exoneracion:show.html.twig', array(
            'form'=>$form->createView(),            
        ));
    }
    
    
    
    
    private function formExoneracion(Exonerados $entity, \Doctrine\ORM\EntityManager $em, $id)
    {
        $form = $this->createForm(new ExoneradosType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_save_exoneracion_alum', array('id'=>$id)),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/exoneracion/delete/{id}", name="app_admin_delete_exoneracion_alum")
     */
    public function deleteExoneracionAction($id){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $exoneracion = $em->getRepository('AppBundle:Exonerados')->find($id);
        $ide = $exoneracion->getEspecialidadEstudiante()->getId();
        $em->remove($exoneracion);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado con exito!');
        return $this->forward('AppBundle:Exoneracion:showExoneracion', array('id'=>$ide));
    }
}