<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * MatriculaRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class MatriculaRepository extends EntityRepository
{
    //nuevo
    public function findMatriculaEstudiante($estudiante, $lapso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND 
                        m.condicion = :condicion AND 
                        o.lapso = :lapso    
                        ")
                        ->setParameter('estudiante', $estudiante)
                        ->setParameter('lapso', $lapso)
                        ->setParameter('condicion', 2)
                ;
        return $query->getResult();
    }
    //usados en el nuevo
    public function findMatriculaEstudianteLapso($estudiante, $lapso, $curso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND                         
                        o.curso = :curso AND 
                        o.lapso = :lapso")
                       ->setParameter('estudiante', $estudiante)                       
                       ->setParameter('curso', $curso)
                       ->setParameter('lapso', $lapso)
                ;
        return $query->getScalarResult();
    }
    
    public function findMatriculaEstudAprob($estudiante)
    {
        $query = $this->getEntityManager()
                      ->createQuery("
                          SELECT m FROM AppBundle:Matricula m 
                          WHERE 
                          m.estudiante = :estudiante AND 
                          m.condicion = :condicion
                          ")
                       ->setParameter('estudiante', $estudiante)
                       ->setParameter('condicion', 3);
        return $query->getResult();
    }
    
    public function findAlumnosByCurso($curso)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :curso
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('curso', $curso);
        return $query->getResult();
                       
    }
    
    public function findMatriculaEstudianteReg($estudiante, $lapso){
        $query = $this->getEntityManager()
                      ->createQuery("
                        SELECT m,o FROM AppBundle:Matricula m
                        LEFT JOIN m.oferta o 
                        WHERE 
                        m.estudiante = :estudiante AND 
                        o.lapso = :lapso    
                        ")
                        ->setParameter('estudiante', $estudiante)
                        ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();
    }
    
    public function findByAlumInscritos($programa, $lapso)
    {
        $query = $this->getEntityManager()
                ->createQuery(
                 "SELECT e, esp FROM AppBundle:Especialidad e 
                  LEFT JOIN e.espeestud esp 
                  LEFT JOIN esp.matricula m 
                  LEFT JOIN m.oferta o
                  WHERE 
                  e.programa = :programa AND                  
                  o.lapso = :lapso 
                  "       
                 )
                ->setParameter('programa', $programa)
                //->setParameter('situa', 1)
                ->setParameter('lapso', $lapso)
                ;
//        $query = $this->getEntityManager()
//                ->createQuery(
//                 "SELECT e, esp FROM AppBundle:Especialidad e 
//                  LEFT JOIN e.espeestud esp 
//                  LEFT JOIN esp.matricula m 
//                  WHERE 
//                  esp.programa = :programa AND 
//                  esp.cod_situa = :situa AND 
//                  esp.cod_lapso = :lapso "       
//                 )
//                ->setParameter('programa', $programa)
//                ->setParameter('situa', 1)
//                ->setParameter('lapso', $lapso)
                ;
        return $query->getResult();        
    }
    
    public function findByMatriculaHist($lapso){
        $query = $this->getEntityManager()
                 ->createQuery("
                 SELECT m, o FROM AppBundle:Matricula m 
                 LEFT JOIN m.oferta o 
                 WHERE 
                 m.condicion != :condicion AND 
                 o.lapso = :lapso 
                 ")
                ->setParameter('condicion', 2)
                ->setParameter('lapso', $lapso);               
        return $query->getResult();
    }
    
    public function findByMatriculaHistInsc($lapso){
        $query = $this->getEntityManager()
                ->createQuery("
                SELECT m, o FROM AppBundle:Matricula m
                LEFT JOIN m.oferta o 
                WHERE 
                m.condicion = :condicion AND 
                o.lapso = :lapso 
                ")
                ->setParameter('condicion', 2)
                ->setParameter('lapso', $lapso);
        return $query->getResult();
    }

    public function getMontoInscritoEstudiante($matricula, $em, $configPrograma){
    $montoInscrito = 0;
        //if($configPrograma->getControlpago()){
            foreach ($matricula as $ent){                
                $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ent->getOferta()->getCurso(), 'modo_transcripcion'=>'2'));
                $costouc = $configPrograma->getMontouc();
                
                if(!$cursoespecial){
                    $costouc = ($costouc * $configPrograma->getPorcentajeuc()); 
                }                    
                if($cursoespecial){
                $uccurso = $cursoespecial->getUc();
                }else{
                    
                $uccurso = $ent->getOferta()->getCurso()->getUc();
                
                }  
                $montoInscrito = $montoInscrito + ($costouc*$uccurso);
            }
        //}
            return $montoInscrito;
    }
    
    public function getUcInscritas($em,$matricula){
        $ucInscrito = 0;
            foreach ($matricula as $ent){                
                $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ent->getOferta()->getCurso()));
                                                 
                if($cursoespecial){
                //$uccurso = $cursoespecial->getUc();
                }else{                        
                $ucInscrito =$ucInscrito + $ent->getOferta()->getCurso()->getUc();

                }              
                
           }
        return $ucInscrito;
    }
    
    public function getMontoUc($em, $ofert, $configPrograma){
        $cursoespecial = $em->getRepository('AppBundle:CursosEspeciales')->findOneBy(array('curso' => $ofert->getCurso()));
        $costouc = $configPrograma->getMontouc();
        if(!$cursoespecial){
            $costouc = ($costouc * $configPrograma->getPorcentajeuc());                           
        }                    
        if($cursoespecial){
        $uccurso = $cursoespecial->getUc();
        }else{
        $uccurso = $ofert->getCurso()->getUc();
        }  
        
        return $montocurso = ($costouc*$uccurso);
    }
    
    /********************
     ***     NUEVO    ***
     ********************/
    
    public function getHistorico($id)
    {
         $query = $this->getEntityManager()
                ->createQuery("
                SELECT m, o FROM AppBundle:Matricula m
                LEFT JOIN m.oferta o 
                WHERE                 
                m.estudiante = :estudiante 
                ")
                ->setParameter('estudiante', $id)
                ;
         
        return $query->getResult();
    }
    
    public function getEstudiantesByOferta($oferta)
    {
        $query = "SELECT m, o FROM AppBundle:Matricula m "
                . "LEFT JOIN m.oferta o "
                . "LEFT JOIN m.estudiante ee "
                . "LEFT JOIN ee.estudiante e "
                . "WHERE "
                . "m.oferta = :oferta "
                . "ORDER BY e.cedula ASC ";
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('oferta', $oferta);
        return $consulta->getResult();
    }
    
    public function getEstudiantesInscritos($lapso, $programa)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa "
                . "ORDER BY e.nombre ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('lapso', $lapso)
                ->setParameter('programa', $programa)
                ;
        return $consulta->getResult();
    }
    
    public function getEstudiantesInscritosByEspecialidad($lapso, $programa, $especialidad)
    {
        $query =  "SELECT e, ee FROM AppBundle:Especialidad e "
                . "LEFT JOIN e.espeestud ee "
                . "LEFT JOIN ee.matricula m "
                . "LEFT JOIN m.oferta o "
                . "WHERE "
                . "o.lapso = :lapso AND "
                . "e.programa = :programa AND "
                . "e.id = :especialidad "
                . "ORDER BY e.nombre ASC "
                ;
        $consulta = $this->getEntityManager()
                ->createQuery($query)
                ->setParameter('lapso', $lapso)
                ->setParameter('programa', $programa)
                ->setParameter('especialidad', $especialidad)
                ;
        return $consulta->getResult();
    }
    //nuevo
    public function findAlumnosByCursoA($curso)
    {
        $query = $this->getEntityManager()
                       ->createQuery("
                           SELECT m, e FROM AppBundle:Matricula m 
                           LEFT JOIN m.estudiante e 
                           LEFT JOIN e.estudiante da
                           WHERE 
                           m.oferta = :curso
                           ORDER BY da.cedula ASC
                       ")
                       ->setParameter('curso', $curso);
        return $query->getResult();
    }
}
