<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * CursosRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CursosRepository extends EntityRepository
{
    public function findByEspecialidadId($especialidad_id, $sede){
          
          $query = $this->getEntityManager()->createQuery(
                'SELECT c 
                 FROM AppBundle:Cursos c 
                 LEFT JOIN c.planestudio p
                 WHERE p.especialidad = :especialidad_id AND 
                       p.sede = :sede 
                 
                 '      
                )
                ->setParameter('especialidad_id', $especialidad_id)
                ->setParameter('sede', $sede);
        return $query->getResult();
        }
        
         public function findSearchTermino($term)
    {
        $query = $this->getEntityManager()->createQuery(
                "SELECT c FROM AppBundle:Cursos c 
                 WHERE  
                 CONCAT(c.codigo, ' ', c.nombre) LIKE :term  OR 
                 c.codigo LIKE :term AND 
                 c.codigo != 1  
                 ORDER BY c.codigo ASC
                "
                )
                ->setParameter('term', '%'.$term.'%')
                ;
        return $query->getResult();
    }
        
    
}
