<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="modo_transcripcion")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ModoTranscripcionRepository")
 */
class ModoTranscripcion {
    //put your code here
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=25)
     */
    protected $descripcion;
    
    /**
     * @ORM\OneToMany(targetEntity="CursosEspeciales", mappedBy="modo_transcripcion")
     */
    protected $cursoespecial;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cursoespecial = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descripcion
     *
     * @param string $descripcion
     * @return ModoTranscripcion
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    
        return $this;
    }

    /**
     * Get descripcion
     *
     * @return string 
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * Add cursoespecial
     *
     * @param AppBundle\Entity\CursosEspeciales $cursoespecial
     * @return ModoTranscripcion
     */
    public function addCursoespecial(\AppBundle\Entity\CursosEspeciales $cursoespecial)
    {
        $this->cursoespecial[] = $cursoespecial;
    
        return $this;
    }

    /**
     * Remove cursoespecial
     *
     * @param AppBundle\Entity\CursosEspeciales $cursoespecial
     */
    public function removeCursoespecial(\AppBundle\Entity\CursosEspeciales $cursoespecial)
    {
        $this->cursoespecial->removeElement($cursoespecial);
    }

    /**
     * Get cursoespecial
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getCursoespecial()
    {
        return $this->cursoespecial;
    }
    
    public function __toString() {
        return $this->getDescripcion();
    }
}
