<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="extensiones_usuarios")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ExtensionesUsuariosRepository")
 */
class ExtensionesUsuarios {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="Usuarios", inversedBy="extensiones")
     * @ORM\JoinColumn(name="usuario_id", referencedColumnName="id")
     */
    protected $usuario;
    
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="extensiones")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    /**
     * @ORM\ManyToOne(targetEntity="Especialidad", inversedBy="extensiones")
     * @ORM\JoinColumn(name="especialidad_id", referencedColumnName="id")
     */
    protected $especialidad;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set usuario
     *
     * @param \AppBundle\Entity\Usuarios $usuario
     * @return ExtensionesUsuarios
     */
    public function setUsuario(\AppBundle\Entity\Usuarios $usuario = null)
    {
        $this->usuario = $usuario;
    
        return $this;
    }

    /**
     * Get usuario
     *
     * @return \AppBundle\Entity\Usuarios 
     */
    public function getUsuario()
    {
        return $this->usuario;
    }

    /**
     * Set subsedes
     *
     * @param \AppBundle\Entity\SubSedes $subsedes
     * @return ExtensionesUsuarios
     */
    public function setSubsedes(\AppBundle\Entity\SubSedes $subsedes = null)
    {
        $this->subsedes = $subsedes;
    
        return $this;
    }

    /**
     * Get subsedes
     *
     * @return \AppBundle\Entity\SubSedes 
     */
    public function getSubsedes()
    {
        return $this->subsedes;
    }

    /**
     * Set especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     * @return ExtensionesUsuarios
     */
    public function setEspecialidad(\AppBundle\Entity\Especialidad $especialidad = null)
    {
        $this->especialidad = $especialidad;
    
        return $this;
    }

    /**
     * Get especialidad
     *
     * @return \AppBundle\Entity\Especialidad 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return ExtensionesUsuarios
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
