<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

use AppBundle\Utils\Util2;
use AppBundle\Utils\Util;

use UsersBundle\Entity\Users;
use UsersBundle\Entity\Role;
use AppBundle\Entity\Usuarios;
use AppBundle\Form\UsuariosType;

use Doctrine\ORM\EntityRepository;

/**
 * Usuarios controller.
 *
 */
class UsuariosController extends Controller
{


    /**
     * Lists all Usuarios entities.
     *
     * @Route("/app/admin/usuarios/", name="app_usuarios_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entities = $em->getRepository('AppBundle:Usuarios')->findAll();

        return $this->render('AppBundle:Usuarios:index.html.twig', array(
            'entities' => $entities,
        ));
    }
    /**
     * Creates a new Usuarios entity.
     *
     * @Route("/app/admin/usuarios/nuevo/", name="app_usuarios_new")
     */
    public function createAction(Request $request)
    {
        
        $em2 = $this->getDoctrine()->getManager();
        $user = new Users();
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Usuarios();
        $form = $this->createCreateForm($entity, $em);
        
        $util = new Util2();
       
        $form->handleRequest($request);

        if ($form->isValid()) {
            
            $data = $form->getData();
            $cedula = $data->getCedula();
            $nombre = $data->getNombre().' '.$data->getApellido();
            $email = $data->getEmail();  
            $password = $data->getPassword();
            $encoder  = $this->get('security.encoder_factory')->getEncoder($user);
            $user->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $user->getSalt());    
            $user->setNombre($nombre);
            $user->setCedula($cedula);
            $user->setEmail($email);
            $user->setPassword($passwordCodifi);
            $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_ADMIN'));
            $user->addUserRole($role);
            $user->setSede($this->getUser()->getSede());
            $user->setActive(1);
            
            $entity->setPassword($password);
            $em2->persist($user);
            
            $ids = $this->getUser()->getSede()->getId();
            $sede = $em->getRepository('AppBundle:Sede')->find($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            $em2->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado con exito!');
            return $this->redirect($this->generateUrl('app_usuarios_show'));
           
        }

        
        return $this->render('AppBundle:Usuarios:new.html.twig', array(
            'entity' => $entity,
            'form'   => $form->createView(),
        ));
       
    }
    
    /**
     * Creates a form to create a Usuarios entity.
     *
     * @param Usuarios $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     * @Route("/app/admin/usuarios/nuevo/", name="app_usuarios_create")
     */
    private function createCreateForm(Usuarios $entity)
    {
        $form = $this->createForm(new UsuariosType(), $entity, array(
            'action' => $this->generateUrl('app_usuarios_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Crear Usuario','attr'=> array('class'=>'btn btn-primary btn-flat')));

        return $form;
    }

    /**
     *
     * @Route("/app/admin/usuarios/lista/", name="app_usuarios_show")
     */
        public function showUsuariosAction()
        {
     
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em')); 
        $form = $this->formConsultUsuarios($em);
       // $user = $this->get('security.token_storage')->getToken()->getUser()->getSede()->getId();

        $query = "SELECT u FROM AppBundle:Usuarios u "
                . "WHERE "
                . "u.cedula != 0 "                                 
                . "ORDER BY u.cedula ASC ";
        
        $entities = $em->createQuery($query); 
        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate($entities,$this->get('request')->query->get('page',1),10);
        
        return $this->render('AppBundle:Usuarios:index.html.twig', array(
            'form'=>$form->createView(),
            'pagination'=>$pagination
        ));
    }
    
    /**
     * 
     * @Route("/app/admin/usuarios/search/", name="app_admin_usuarios_search")
     */
    public function searchAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $text = $request->get('text');
        //$user = $this->get('security.token_storage')->getToken()->getUser()->getSede()->getId();

        
        $query = "SELECT u FROM AppBundle:Usuarios u "
                . " WHERE "
                . " u.cedula LIKE :text OR "
                . " u.nombre LIKE :text "
                . " ORDER BY u.cedula ASC ";
        
        $entities = $em->createQuery($query); 
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Usuarios:index.html.twig', array(            
            'pagination'=>$pagination   
        ));
    }    
    
    /**
     * @Route("/app/admin/usuarios/editar/{id}", name="app_usuarios_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);
        $form = $this->formEdit($entities, $em);
                    
        return $this->render('AppBundle:Usuarios:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }

     private function formEdit(Usuarios $entities, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new UsuariosType($em), $entities, array(
            'action'=>$this->generateUrl('app_usuarios_update_edit', array('id'=>$entities->getId())),
            'method'=>'PUT')) 
             ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')));
             
        return $form;
    }

    /**
     * @Route("/app/admin/usuarios/actualizar/{id}", name="app_usuarios_update_edit", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulausuario = $entities->getCedula();
	//echo $cedulausuario;die();
        $entities2 = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedulausuario));
// 	var_dump($iduser); die();
     //   $entities2 = $em2->getRepository('UsersBundle:Users')->find($iduser->getId());


        $form = $this->formEdit($entities, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            
           if ($form->get('submit')->isClicked()) {
            $em->persist($entities);
            $em->flush();

            //$password = $this->get('request')->request->get('password');
            $password = $entities->getPassword();
            $email = $entities->getEmail();

            $encoder  = $this->get('security.encoder_factory')->getEncoder($entities2);
            $entities2->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $entities2->getSalt());
            $entities2->setPassword($passwordCodifi);
            $entities2->setEmail($email);

            $em2->persist($entities2);
            $em2->flush();

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
           } 
            
            return $this->redirect($this->generateUrl('app_usuarios_show'));
        }
        
        return $this->render('AppBundle:Usuarios:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formConsultUsuarios(\Doctrine\ORM\EntityManager $em){
        $form = $this->createFormBuilder()
            ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('nombre', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('apellido', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('password', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('email', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm();
        return $form;
    }

/*SIN USAR SIN USAR SIN USAR
    
     /**
     * Finds and displays a Usuarios entity.
     *
     * @Route("/app/admin/usuarios/", name="app_usuarios_show")
     
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entity = $em->getRepository('AppBundle:Usuarios')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Usuarios entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('AppBundle:Usuarios:show.html.twig', array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),
        ));
    }
    
    /**
     * Deletes a Usuarios entity.
     *
     * @Route("/app/admin/usuarios/eliminar", name="app_usuarios_eliminar")
     
    public function deleteAction(Request $request, $id)
    {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $entity = $em->getRepository('AppBundle:Usuarios')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Usuarios entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('usuarios'));
    }

    /**
     * Creates a form to delete a Usuarios entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     * @Route("/app/admin/usuarios", name="app_usuarios_delete")
     
    private function createDeleteForm($id)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('app_usuarios_delete', array('id' => $id)))
            ->setMethod('DELETE')
            ->add('submit', 'submit', array('label' => 'Delete'))
            ->getForm()
        ;
    }

  SIN USAR SIN USAR SIN USAR*/
}
