<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Profesor;
use AppBundle\Form\ProfesorType;
use AppBundle\Utils\Util2;
use UsersBundle\Entity\Users;

/**
 * Description of ProfesoresController
 *
 * @author jose
 */
class ProfesoresController  extends Controller {
    
    /**
     * @Route("/app/admin/profesores", name="app_admin_profesores")
     */
    public function indexAction(){
        $form = $this->formConsultProfesor();
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT p FROM AppBundle:Profesor p "
                . "WHERE "
                . "p.cedula != 1 and p.activo != 0 "                                        
                . "ORDER BY p.cedula ASC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Profesores:index.html.twig', array(
            'form'=>$form->createView(),
            'pagination'=>$pagination
        ));
    }
    
    private function formConsultProfesor(){
        $form = $this->createFormBuilder()
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm();
        return $form;
    }
    
    /**
     * @Route("/app/admin/edit/profesor/{id}", name="app_admin_edit_profesor")
     */
    public function editProfesorAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);
        $form = $this->formEditProfesor($entity, $em);
        
        return $this->render('AppBundle:Profesores:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/profesor/{id}", name="app_admin_update_profesor", requirements={"_method":"PUT"})
     */
    public function updateProfesorAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Profesor')->find($id);
        $form = $this->formEditProfesor($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_profesores'));
        }
        
        return $this->render('AppBundle:Profesores:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formEditProfesor(Profesor $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_update_profesor', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/profesor", name="app_admin_new_profesor")
     */
    public function newProfesorAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Profesor();
        $form = $this->formCreateProfesor($entity, $em);
        
        return $this->render('AppBundle:Profesores:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/profesor", name="app_admin_create_profesor", requirements={"_method":"POST"})
     */
    public function createProfesorAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $em2 = $this->getDoctrine()->getManager();
        $user = new Users();
        
        $entity = new Profesor();
        $form = $this->formCreateProfesor($entity, $em);
        
        $form->handleRequest($request);
        $util = new Util2();
        
        
        if($form->isValid())
        {
            $data = $form->getData();
            $cedula = $data->getCedula();
            $nombre = $data->getPrimerNombre().' '.$data->getPrimerApellido();
            $email = $data->getEmail();            
            $password = $util->generarPassword(10);            
            $encoder  = $this->get('security.encoder_factory')->getEncoder($user);
            $user->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $user->getSalt());
            $user->setNombre($nombre);
            $user->setCedula($cedula);
            $user->setEmail($email);
            $user->setPassword($passwordCodifi);
            $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_PROF'));
            $user->addUserRole($role);
            $user->setSede($this->getUser()->getSede());
            $user->setActive(1);
            
            $entity->setPassword($password);
            $em2->persist($user);
            
            
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            $em2->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado con exito!');
            return $this->redirect($this->generateUrl('app_admin_profesores'));
        }
        
        return $this->render('AppBundle:Profesores:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formCreateProfesor(Profesor $entity, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new ProfesorType($em), $entity, array(
            'action'=>$this->generateUrl('app_admin_create_profesor'),
            'method'=>'POST'            
        ))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/search/profesores", name="app_admin_profesores_search")
     */
    public function searchAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT p FROM AppBundle:Profesor p "
                . "WHERE "
                . "p.cedula != 1 AND "
                . "p.cedula LIKE :text OR "
                . "p.primer_nombre LIKE :text OR "                                       
                . "p.primer_apellido LIKE :text "                                                       
                . "ORDER BY p.cedula ASC ";
        $entities = $em->createQuery($query);
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Profesores:index.html.twig', array(            
            'pagination'=>$pagination
        ));
    }
                
} 