<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\HistMatri;
/**
 * Description of HistoricoController
 *
 * @author jose
 */
class HistoricoController extends Controller {
    
    /**
     * @Route("/app/admin/hisotico", name="app_estudiantes_historico_index")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Historico:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_historico_especialidad'))
                ->setMethod('POST')
                ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
            ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/historico/especialied", name="app_historico_especialidad")
     */
    public function serchEspecialidadAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formSearchEstudiante();
        
        if($request->getMethod()=='POST')
        {
            $form->handleRequest($request);
            $cedula = $form['cedula']->getData();
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_index'));
            }
            
            return $this->render('AppBundle:Historico:result.html.twig', array(
                'datos'=>$estudiante
            ));
        }
         return $this->render('AppBundle:Historico:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/historico/show", name="app_historico_show")
     */
    public function showHistoricoAction(Request $request)    
    {
        $id = $request->get('especialidad');
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));        
        
        //$datos = $request->get('form');
        $estudiante = $em->getRepository('AppBundle:EspeEstud')->find($id);        
        $historico = $em->getRepository('AppBundle:HistMatri')->findCursos($id);
        
        $totuc=0;
        $totuccal=0;
        foreach ($historico as $value)
        {          
            $uc = $value->getCurso()->getUc();            
            $nota = $value->getNota();
            $cursopla = $em->getRepository('AppBundle:PlanEstudio')->findBy(array('curso'=>$value->getCurso()->getId(), 'componentes'=>4));
            
            if($cursopla){
                
            }else{
            if(in_array($value->getCondicion()->getId(), array(7,10)))
            {}else{
            $totuc += $uc;
            $totuccal += ($uc*$nota);
            }
            }            
            
        }
        $trabajos = array();
        $arrayTrabajos = $em->createQuery("SELECT c.codigo FROM AppBundle:CursosEspeciales ce 
            LEFT JOIN ce.curso c 
            WHERE 
            ce.modo_transcripcion in(:condicion)")->setParameter('condicion', array(2))->getArrayResult();
        foreach ($arrayTrabajos as $value){
            $trabajos[$value['codigo']]= $value['codigo'];
        }
        
        $condicion = $em->getRepository('AppBundle:CondCurso')->findAll();
        $lapsos = $em->getRepository('AppBundle:Lapso')->findBySede($this->getUser()->getSede()->getId());
        @$indice = $totuccal / $totuc;
        return $this->render('AppBundle:Historico:show.html.twig', 
                array('historico'=>$historico, 'estudiante'=>$estudiante, 'uc'=>$totuc, 'totuccal'=>$totuccal, 'indice'=>$indice, 'trabajos'=>$trabajos, 'condiciones'=>$condicion, 'lapsos'=>$lapsos));
        
        return $this->render('AppBundle:Historico:show.html.twig', array(
            'entities'=>$entities
        ));        
    }
    
    /**
     * @Route("/app/admin/historico/consult", name="app_admin_historico_consult")
     */
    public function consultDatosCursoAction()
    {
        $id = $this->getRequest()->get('id');        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));  
        $curso = $em->getRepository('AppBundle:HistMatri')->find($id);                           ;
       
                $dato['nota'] = $curso->getNota();
                $dato['seccion'] = $curso->getSeccion();
                $dato['grupo'] = $curso->getGrupo();
                $dato['lapso'] = $curso->getLapso()->getId();
                $dato['condicion'] = $curso->getCondicion()->getId();
                $dato['text'] = $curso->getObs();
                $response[] = $dato;             
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
    }
    
    /**
     * @Route("/app/admin/historico/update", name="app_historico_estudiante_update", requirements={"_method":"PUT"})
     */
    public function updateTwoHistoricoAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));  
        $curso = $request->get('curso');
        $lapso = $request->get('lapso');
        $condicion = $request->get('condicion');
        $estudiante = $request->get('estudiante');
        $grupo = $request->get('grupo');
        $nota = $request->get('nota');
        $seccion = $request->get('seccion');
        $observacion = $request->get('observacion');
        //$espeestud = $em->getRepository('AppBundle:EspeEstud')->find($estudiante);
        
        $lap = $em->getRepository('AppBundle:Lapso')->find($lapso);
        $cond = $em->getRepository('AppBundle:CondCurso')->find($condicion);
        
        
        $historico = $em->getRepository('AppBundle:HistMatri')->find($curso);    
        
        $historico->setCondicion($cond);
        $historico->setLapso($lap);
        $historico->setNota($nota);
        $historico->setSeccion($seccion);
        $historico->setGrupo($grupo);
        $historico->setObs($observacion);

        $em->persist($historico);
        
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('msg-success', 'HISTORICO MODIFICADO CON EXITO!');
        
        //return $this->redirect($this->generateUrl('show_cargar_historico_estud', array('form'=>$form)));
        return $this->forward('AppBundle:Historico:showHistorico', array('especialidad'=>$estudiante));            
    }
    
    /**
     * @Route("/app/admin/historico/save", name="app_admin_save_historico", requirements={"_method":"POST"})
     */
    public function saveOneHistoricoAction(Request $request)
    {        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));  
        $curso = $request->get('curso');
        $lapso = $request->get('lapso');
        $condicion = $request->get('condicion');
        $estudiante = $request->get('estudiante');
        $grupo = $request->get('grupo');
        $nota = $request->get('nota');
        $seccion = $request->get('seccion');
        $observacion = $request->get('observacion');
        $espeestud = $em->getRepository('AppBundle:EspeEstud')->find($estudiante);
        $lap = $em->getRepository('AppBundle:Lapso')->find($lapso);
        $cond = $em->getRepository('AppBundle:CondCurso')->find($condicion);
        $curs = $em->getRepository('AppBundle:Cursos')->find($curso);
        $historico = new HistMatri();
        
        $historico->setEstudiante($espeestud);
        $historico->setCondicion($cond);
        $historico->setCurso($curs);
        $historico->setLapso($lap);
        $historico->setNota($nota);
        $historico->setSeccion($seccion);
        $historico->setUc($curs->getUc());
        $historico->setGrupo($grupo);
        $historico->setObs($observacion);
        $historico->setEspecialidad($espeestud->getEspecialidad());
        $historico->setPrograma($espeestud->getPrograma());
        $ids = $this->getUser()->getSede()->getId();
        $sede = $em->getRepository('AppBundle:Sede')->find($ids);
        $historico->setSede($sede);
        
        $em->persist($historico);
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('msg-success', 'HISTORICO MODIFICADO CON EXITO!');
        
        return $this->forward('AppBundle:Historico:showHistorico', array('especialidad'=>$estudiante));        
    }
    
    /**
     * @Route("/app/admin/historico/delete", name="app_admin_historico_delete", requirements={"_method":"DELETE"})
     */
    public function deleteHistoricoAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));  
        
        $estudiante = $request->get('estudiante');
        $curso = $request->get('curso_delete');
        
        $matricula = $em->getRepository('AppBundle:HistMatri')->find($curso);
        
        $em->remove($matricula);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'REGISTRO ELIMINADO CON EXITO!');
        
        return $this->forward('AppBundle:Historico:showHistorico', array('especialidad'=>$estudiante));
    }
}
