<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Doctrine\ORM\EntityManager;

class AutoridadesType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    private $em;
    public function __construct(EntityManager $em) {
        $this->em = $em;
    }



    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('titulo')
            ->add('nombre')
            ->add('apellido')
            ->add('cargo', 'choice', array('empty_value'=>'.:Seleccione:.','choices'=>array('12'=>'Jefe(a) de Control de Estudios'
                                                                                            )))
            ->add('subsede', 'entity', array(
                'class'=>'AppBundle:SubSede',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control'),
                'label'=>'Extensión'
            ))

	    ->add('sede', 'entity', array(
                'class'=>'AppBundle:Sede',
                'em'=>$this->em,
                'attr'=>array('class'=>'form-control'),
                'label'=>'Sede'
            ))
	    ->add('cedula')
 	    ->add('activo')
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Autoridades'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'appbundle_autoridades';
    }
}
