<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="sede")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\SedeRepository")
 */
class Sede {
 
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\Column(type="string", length=20, unique=true)
     */
    protected $codigo;
    
    /**
     * @ORM\Column(type="string", length=70)
     */
    protected $nombre;
    
    /**
     * @ORM\OneToMany(targetEntity="EspeEstud", mappedBy="sede")
     */
    protected $espeestud;

    /**
     * @ORM\OneToMany(targetEntity="OfertAcade", mappedBy="sede")
     */
    protected $oferacade;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatri", mappedBy="sede")
     */
    protected $histmatri;
    
    /**
     * @ORM\OneToMany(targetEntity="HistMatriEgresado", mappedBy="sede")
     */
    protected $histmatriegresado;
           
    /**
     * @ORM\OneToMany(targetEntity="Usuarios", mappedBy="sede")
     */
    protected $usuario;
    
    /**
     * @ORM\OneToMany(targetEntity="Procesos", mappedBy="sede")
     */
    protected $procesos;
    
    /**
     * @ORM\OneToMany(targetEntity="Uc", mappedBy="sede")
     */
    protected $uc;
    
    /**
     * @ORM\OneToMany(targetEntity="Promociones", mappedBy="sede")
     */
    protected $promocion;
    
    /**
     * @ORM\OneToMany(targetEntity="Especialidad", mappedBy="sede")
     */
    protected $especialidad;
    
    /**
     * @ORM\OneToMany(targetEntity="PlanEstudio", mappedBy="sede")
     */
    protected $planestudio;
    
    /**
     * @ORM\OneToMany(targetEntity="MontoCurso", mappedBy="sede")
     */
    protected $montocurso;
    
    /**
     * @ORM\OneToMany(targetEntity="Profesor", mappedBy="sede")
     */
    protected $profesor;
    
    /**
     * @ORM\OneToMany(targetEntity="Lapso", mappedBy="sede")
     */
    protected $lapso;
    
    /**
     * @ORM\OneToMany(targetEntity="Cursos", mappedBy="sede")
     */
    protected $cursos;

    /**
     * @ORM\OneToMany(targetEntity="BloqueHoras", mappedBy="sede")
     */
    protected $hora;
    
    /**
     * @ORM\OneToMany(targetEntity="Cohorte", mappedBy="sede")
     */
    protected $cohorte; 
    
    /**
     * @ORM\OneToMany(targetEntity="SubSede", mappedBy="sede")
     */
    protected $subsede;
    
    /**
     * @ORM\OneToMany(targetEntity="CreditosGraduando", mappedBy="sede")
     */
    protected $creditos;
    
    /**
     * @ORM\OneToMany(targetEntity="Exonerados", mappedBy="sede")
     */
    protected $exonerados;
    /**
     * @ORM\OneToMany(targetEntity="Autoridades", mappedBy="sede")
     */
    protected $autoridades;
    /**
     * @ORM\OneToMany(targetEntity="ControlPagos", mappedBy="sede")
     */
    protected $controlpagos;

    /**
     * @ORM\OneToMany(targetEntity="ConfigSistema", mappedBy="sede")
     */
    protected $configsistema;
    /**
     * @ORM\OneToMany(targetEntity="Depositos", mappedBy="sede")
     */
    protected $depositos;

    // METODOS GENERADOS PARA LAS CONSULTAS //
    
    
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->espeestud = new \Doctrine\Common\Collections\ArrayCollection();
        $this->oferacade = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatri = new \Doctrine\Common\Collections\ArrayCollection();
        $this->histmatriegresado = new \Doctrine\Common\Collections\ArrayCollection();
        $this->usuario = new \Doctrine\Common\Collections\ArrayCollection();
        $this->procesos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->uc = new \Doctrine\Common\Collections\ArrayCollection();
        $this->promocion = new \Doctrine\Common\Collections\ArrayCollection();
        $this->especialidad = new \Doctrine\Common\Collections\ArrayCollection();
        $this->planestudio = new \Doctrine\Common\Collections\ArrayCollection();
        $this->montocurso = new \Doctrine\Common\Collections\ArrayCollection();
        $this->profesor = new \Doctrine\Common\Collections\ArrayCollection();
        $this->lapso = new \Doctrine\Common\Collections\ArrayCollection();
        $this->cursos = new \Doctrine\Common\Collections\ArrayCollection();
        $this->hora = new \Doctrine\Common\Collections\ArrayCollection();
        $this->cohorte = new \Doctrine\Common\Collections\ArrayCollection();
        $this->subsede = new \Doctrine\Common\Collections\ArrayCollection();
        $this->creditos = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return Sede
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    
        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     * @return Sede
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;
    
        return $this;
    }

    /**
     * Get nombre
     *
     * @return string 
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Add espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     * @return Sede
     */
    public function addEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud[] = $espeestud;
    
        return $this;
    }

    /**
     * Remove espeestud
     *
     * @param \AppBundle\Entity\EspeEstud $espeestud
     */
    public function removeEspeestud(\AppBundle\Entity\EspeEstud $espeestud)
    {
        $this->espeestud->removeElement($espeestud);
    }

    /**
     * Get espeestud
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspeestud()
    {
        return $this->espeestud;
    }

    /**
     * Add oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     * @return Sede
     */
    public function addOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade[] = $oferacade;
    
        return $this;
    }

    /**
     * Remove oferacade
     *
     * @param \AppBundle\Entity\OfertAcade $oferacade
     */
    public function removeOferacade(\AppBundle\Entity\OfertAcade $oferacade)
    {
        $this->oferacade->removeElement($oferacade);
    }

    /**
     * Get oferacade
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getOferacade()
    {
        return $this->oferacade;
    }

    /**
     * Add histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     * @return Sede
     */
    public function addHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri[] = $histmatri;
    
        return $this;
    }

    /**
     * Remove histmatri
     *
     * @param \AppBundle\Entity\HistMatri $histmatri
     */
    public function removeHistmatri(\AppBundle\Entity\HistMatri $histmatri)
    {
        $this->histmatri->removeElement($histmatri);
    }

    /**
     * Get histmatri
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatri()
    {
        return $this->histmatri;
    }

    /**
     * Add histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     * @return Sede
     */
    public function addHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado[] = $histmatriegresado;
    
        return $this;
    }

    /**
     * Remove histmatriegresado
     *
     * @param \AppBundle\Entity\HistMatriEgresado $histmatriegresado
     */
    public function removeHistmatriegresado(\AppBundle\Entity\HistMatriEgresado $histmatriegresado)
    {
        $this->histmatriegresado->removeElement($histmatriegresado);
    }

    /**
     * Get histmatriegresado
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHistmatriegresado()
    {
        return $this->histmatriegresado;
    }

    /**
     * Add usuario
     *
     * @param \AppBundle\Entity\Usuarios $usuario
     * @return Sede
     */
    public function addUsuario(\AppBundle\Entity\Usuarios $usuario)
    {
        $this->usuario[] = $usuario;
    
        return $this;
    }

    /**
     * Remove usuario
     *
     * @param \AppBundle\Entity\Usuarios $usuario
     */
    public function removeUsuario(\AppBundle\Entity\Usuarios $usuario)
    {
        $this->usuario->removeElement($usuario);
    }

    /**
     * Get usuario
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUsuario()
    {
        return $this->usuario;
    }

    /**
     * Add procesos
     *
     * @param \AppBundle\Entity\Procesos $procesos
     * @return Sede
     */
    public function addProceso(\AppBundle\Entity\Procesos $procesos)
    {
        $this->procesos[] = $procesos;
    
        return $this;
    }

    /**
     * Remove procesos
     *
     * @param \AppBundle\Entity\Procesos $procesos
     */
    public function removeProceso(\AppBundle\Entity\Procesos $procesos)
    {
        $this->procesos->removeElement($procesos);
    }

    /**
     * Get procesos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getProcesos()
    {
        return $this->procesos;
    }

    /**
     * Add uc
     *
     * @param \AppBundle\Entity\Uc $uc
     * @return Sede
     */
    public function addUc(\AppBundle\Entity\Uc $uc)
    {
        $this->uc[] = $uc;
    
        return $this;
    }

    /**
     * Remove uc
     *
     * @param \AppBundle\Entity\Uc $uc
     */
    public function removeUc(\AppBundle\Entity\Uc $uc)
    {
        $this->uc->removeElement($uc);
    }

    /**
     * Get uc
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUc()
    {
        return $this->uc;
    }

    /**
     * Add promocion
     *
     * @param \AppBundle\Entity\Promociones $promocion
     * @return Sede
     */
    public function addPromocion(\AppBundle\Entity\Promociones $promocion)
    {
        $this->promocion[] = $promocion;
    
        return $this;
    }

    /**
     * Remove promocion
     *
     * @param \AppBundle\Entity\Promociones $promocion
     */
    public function removePromocion(\AppBundle\Entity\Promociones $promocion)
    {
        $this->promocion->removeElement($promocion);
    }

    /**
     * Get promocion
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPromocion()
    {
        return $this->promocion;
    }

    /**
     * Add especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     * @return Sede
     */
    public function addEspecialidad(\AppBundle\Entity\Especialidad $especialidad)
    {
        $this->especialidad[] = $especialidad;
    
        return $this;
    }

    /**
     * Remove especialidad
     *
     * @param \AppBundle\Entity\Especialidad $especialidad
     */
    public function removeEspecialidad(\AppBundle\Entity\Especialidad $especialidad)
    {
        $this->especialidad->removeElement($especialidad);
    }

    /**
     * Get especialidad
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEspecialidad()
    {
        return $this->especialidad;
    }

    /**
     * Add planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     * @return Sede
     */
    public function addPlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio[] = $planestudio;
    
        return $this;
    }

    /**
     * Remove planestudio
     *
     * @param \AppBundle\Entity\PlanEstudio $planestudio
     */
    public function removePlanestudio(\AppBundle\Entity\PlanEstudio $planestudio)
    {
        $this->planestudio->removeElement($planestudio);
    }

    /**
     * Get planestudio
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlanestudio()
    {
        return $this->planestudio;
    }

    /**
     * Add montocurso
     *
     * @param \AppBundle\Entity\MontoCurso $montocurso
     * @return Sede
     */
    public function addMontocurso(\AppBundle\Entity\MontoCurso $montocurso)
    {
        $this->montocurso[] = $montocurso;
    
        return $this;
    }

    /**
     * Remove montocurso
     *
     * @param \AppBundle\Entity\MontoCurso $montocurso
     */
    public function removeMontocurso(\AppBundle\Entity\MontoCurso $montocurso)
    {
        $this->montocurso->removeElement($montocurso);
    }

    /**
     * Get montocurso
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getMontocurso()
    {
        return $this->montocurso;
    }

    /**
     * Add profesor
     *
     * @param \AppBundle\Entity\Profesor $profesor
     * @return Sede
     */
    public function addProfesor(\AppBundle\Entity\Profesor $profesor)
    {
        $this->profesor[] = $profesor;
    
        return $this;
    }

    /**
     * Remove profesor
     *
     * @param \AppBundle\Entity\Profesor $profesor
     */
    public function removeProfesor(\AppBundle\Entity\Profesor $profesor)
    {
        $this->profesor->removeElement($profesor);
    }

    /**
     * Get profesor
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getProfesor()
    {
        return $this->profesor;
    }

    /**
     * Add lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     * @return Sede
     */
    public function addLapso(\AppBundle\Entity\Lapso $lapso)
    {
        $this->lapso[] = $lapso;
    
        return $this;
    }

    /**
     * Remove lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     */
    public function removeLapso(\AppBundle\Entity\Lapso $lapso)
    {
        $this->lapso->removeElement($lapso);
    }

    /**
     * Get lapso
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Add cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     * @return Sede
     */
    public function addCurso(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos[] = $cursos;
    
        return $this;
    }

    /**
     * Remove cursos
     *
     * @param \AppBundle\Entity\Cursos $cursos
     */
    public function removeCurso(\AppBundle\Entity\Cursos $cursos)
    {
        $this->cursos->removeElement($cursos);
    }

    /**
     * Get cursos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCursos()
    {
        return $this->cursos;
    }

    /**
     * Add hora
     *
     * @param \AppBundle\Entity\BloqueHoras $hora
     * @return Sede
     */
    public function addHora(\AppBundle\Entity\BloqueHoras $hora)
    {
        $this->hora[] = $hora;
    
        return $this;
    }

    /**
     * Remove hora
     *
     * @param \AppBundle\Entity\BloqueHoras $hora
     */
    public function removeHora(\AppBundle\Entity\BloqueHoras $hora)
    {
        $this->hora->removeElement($hora);
    }

    /**
     * Get hora
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getHora()
    {
        return $this->hora;
    }

    /**
     * Add cohorte
     *
     * @param \AppBundle\Entity\Cohorte $cohorte
     * @return Sede
     */
    public function addCohorte(\AppBundle\Entity\Cohorte $cohorte)
    {
        $this->cohorte[] = $cohorte;
    
        return $this;
    }

    /**
     * Remove cohorte
     *
     * @param \AppBundle\Entity\Cohorte $cohorte
     */
    public function removeCohorte(\AppBundle\Entity\Cohorte $cohorte)
    {
        $this->cohorte->removeElement($cohorte);
    }

    /**
     * Get cohorte
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCohorte()
    {
        return $this->cohorte;
    }

    /**
     * Add subsedes
     *
     * @param \AppBundle\Entity\SubSedes $subsedes
     * @return Sede
     */
    public function addSubsede(\AppBundle\Entity\SubSede $subsede)
    {
        $this->subsede[] = $subsede;
    
        return $this;
    }

    /**
     * Remove subsedes
     *
     * @param \AppBundle\Entity\SubSedes $subsedes
     */
    public function removeSubsede(\AppBundle\Entity\SubSede $subsede)
    {
        $this->subsede->removeElement($subsede);
    }

    /**
     * Get subsedes
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSubsede()
    {
        return $this->subsede;
    }

    /**
     * Add creditos
     *
     * @param \AppBundle\Entity\CreditosGraduando $creditos
     * @return Sede
     */
    public function addCredito(\AppBundle\Entity\CreditosGraduando $creditos)
    {
        $this->creditos[] = $creditos;
    
        return $this;
    }

    /**
     * Remove creditos
     *
     * @param \AppBundle\Entity\CreditosGraduando $creditos
     */
    public function removeCredito(\AppBundle\Entity\CreditosGraduando $creditos)
    {
        $this->creditos->removeElement($creditos);
    }

    /**
     * Get creditos
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreditos()
    {
        return $this->creditos;
    }
    
    public function __toString() {
        return $this->getNombre();
    }

    /**
     * Add exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     * @return Sede
     */
    public function addExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados[] = $exonerados;
    
        return $this;
    }

    /**
     * Remove exonerados
     *
     * @param \AppBundle\Entity\Exonerados $exonerados
     */
    public function removeExonerado(\AppBundle\Entity\Exonerados $exonerados)
    {
        $this->exonerados->removeElement($exonerados);
    }

    /**
     * Get exonerados
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getExonerados()
    {
        return $this->exonerados;
    }
    
  

    /**
     * Add autoridade
     *
     * @param \AppBundle\Entity\Autoridades $autoridade
     *
     * @return Sede
     */
    public function addAutoridade(\AppBundle\Entity\Autoridades $autoridade)
    {
        $this->autoridades[] = $autoridade;

        return $this;
    }

    /**
     * Remove autoridade
     *
     * @param \AppBundle\Entity\Autoridades $autoridade
     */
    public function removeAutoridade(\AppBundle\Entity\Autoridades $autoridade)
    {
        $this->autoridades->removeElement($autoridade);
    }

    /**
     * Get autoridades
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAutoridades()
    {
        return $this->autoridades;
    }
 

    /**
     * Add controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     *
     * @return Sede
     */
    public function addControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos[] = $controlpago;

        return $this;
    }

    /**
     * Remove controlpago
     *
     * @param \AppBundle\Entity\ControlPagos $controlpago
     */
    public function removeControlpago(\AppBundle\Entity\ControlPagos $controlpago)
    {
        $this->controlpagos->removeElement($controlpago);
    }

    /**
     * Get controlpagos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getControlpagos()
    {
        return $this->controlpagos;
    }

    /**
     * Add configsistema
     *
     * @param \AppBundle\Entity\ConfigSistema $configsistema
     *
     * @return Sede
     */
    public function addConfigsistema(\AppBundle\Entity\ConfigSistema $configsistema)
    {
        $this->configsistema[] = $configsistema;

        return $this;
    }

    /**
     * Remove configsistema
     *
     * @param \AppBundle\Entity\ConfigSistema $configsistema
     */
    public function removeConfigsistema(\AppBundle\Entity\ConfigSistema $configsistema)
    {
        $this->configsistema->removeElement($configsistema);
    }

    /**
     * Get configsistema
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getConfigsistema()
    {
        return $this->configsistema;
    }

    /**
     * Add deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     *
     * @return Sede
     */
    public function addDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos[] = $deposito;

        return $this;
    }

    /**
     * Remove deposito
     *
     * @param \AppBundle\Entity\Depositos $deposito
     */
    public function removeDeposito(\AppBundle\Entity\Depositos $deposito)
    {
        $this->depositos->removeElement($deposito);
    }

    /**
     * Get depositos
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDepositos()
    {
        return $this->depositos;
    }
}
