<?php

namespace AppBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * LapsoRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class LapsoRepository extends EntityRepository
{
    
    public function findBySede($sede){
        $query = $this->getEntityManager()->createQuery("
                        SELECT l FROM AppBundle:Lapso l 
                        WHERE 
                        l.sede = :sede 
                        ORDER BY l.codigo DESC                       
                        ")
                       ->setParameter('sede', $sede)
                       ->setMaxResults(90)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByCodigo($codigo){
        $query = $this->getEntityManager()->createQuery("
                        SELECT l FROM AppBundle:Lapso l 
                        WHERE 
                        l.codigo = :codigo                        
                        ")
                       ->setParameter('codigo', $codigo)
                       ->getResult();
                       ;
        return $query;
    }
    
    public function findOneByPeriodo($fechanow){
        $query = $this->getEntityManager()->createQuery("
                        SELECT l FROM AppBundle:Lapso l  
                        WHERE 
                        l.fecha_inicial <= :fechanow AND
                        l.fecha_final >= :fechanow
                        ORDER BY l.codigo ASC                         
                        ")
                       ->setParameter('fechanow', $fechanow)
                       //->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findByPeriodoT($id){
        $query = $this->getEntityManager()->createQuery("
                        SELECT l FROM AppBundle:Lapso l  
                        WHERE 
                        l.id = :id                        
                        ")
                       ->setParameter('id', $id)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }

    public function findEditable($id, $codigo){
        $query = $this->getEntityManager()->createQuery("
                        SELECT l FROM AppBundle:Lapso l  
                        WHERE 
                        l.id != :id AND
                        l.codigo = :codigo                       
                        ")
                       ->setParameter('id', $id)
                       ->setParameter('codigo', $codigo)
                       ->setMaxResults(1)
                       ->getResult();
                       ;
        return $query;
    }
    
}
