<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

use AppBundle\Utils\Util2;
use AppBundle\Utils\Util;

use UsersBundle\Entity\Users;
use UsersBundle\Entity\Role;
use AppBundle\Entity\Usuarios;
use AppBundle\Form\UsuariosType;

use Doctrine\ORM\EntityRepository;

/**
 * Usuarios controller.
 *
 */
class UsuariosController extends Controller
{


    /**
     * Lists all Usuarios entities.
     *
     * @Route("/app/admin/usuarios/", name="app_usuarios_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entities = $em->getRepository('AppBundle:Usuarios')->findAll();

        return $this->render('AppBundle:Usuarios:index.html.twig', array(
            'entities' => $entities,
        ));
    }
    /**
     * Creates a new Usuarios entity.
     *
     * @Route("/app/admin/usuarios/nuevo/", name="app_usuarios_new")
     */
    public function createAction(Request $request)
    {
        
        $em2 = $this->getDoctrine()->getManager();
        $user = new Users();
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Usuarios();
        $form = $this->createCreateForm($entity, $em);
        
        $util = new Util2();
       
        $form->handleRequest($request);

        if ($form->isValid()) {
            
            $data = $form->getData();
            $cedula = $data->getCedula();
            $nombre = $data->getNombre().' '.$data->getApellido();
            $email = $data->getEmail();
            //$activo = $data->getActivo();  
            $password = $data->getPassword();
            $encoder  = $this->get('security.encoder_factory')->getEncoder($user);
            $user->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $user->getSalt());    
            $issetUsuarioE = $em2->getRepository('UsersBundle:Users')->findBy(['email'=>$email]);
            $issetUsuarioC = $em->getRepository('AppBundle:Usuarios')->findBy(['cedula'=>$cedula]);
            if(!$issetUsuarioE and !$issetUsuarioC){
                $user->setNombre($nombre);
                $user->setCedula($cedula);
                $user->setEmail($email);
                $user->setPassword($passwordCodifi);
                $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_ADMIN'));
                $user->addUserRole($role);
                $user->setSede($this->getUser()->getSede());
                $user->setActive(1);
                
                $entity->setPassword($password);
                $em2->persist($user);
            }else if ($issetUsuarioE){
               $this->get('session')->getFlashBag()->add('msg-error', 'CORREO YA REGISTRADO');
               return $this->redirect($this->generateUrl('app_admin_new_profesor'));
            }else{
               $this->get('session')->getFlashBag()->add('msg-error', 'CÉDULA YA REGISTRADA');
               return $this->redirect($this->generateUrl('app_admin_new_profesor'));
            }
            
            $ids = $this->getUser()->getSede()->getId();
            $sede = $em->getRepository('AppBundle:Sede')->find($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            $em2->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado con exito!');
            return $this->redirect($this->generateUrl('app_usuarios_show'));
           
        }

        
        return $this->render('AppBundle:Usuarios:new.html.twig', array(
            'entity' => $entity,
            'form'   => $form->createView(),
        ));
       
    }
    
    /**
     * Creates a form to create a Usuarios entity.
     *
     * @param Usuarios $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     * @Route("/app/admin/usuarios/nuevo/", name="app_usuarios_create")
     */
    private function createCreateForm(Usuarios $entity)
    {
        $form = $this->createForm(new UsuariosType(), $entity, array(
            'action' => $this->generateUrl('app_usuarios_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Crear Usuario','attr'=> array('class'=>'btn btn-primary btn-flat')));

        return $form;
    }

    /**
     *
     * @Route("/app/admin/usuarios/lista/", name="app_usuarios_show")
     */
        public function showUsuariosAction()
        {
     
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em')); 
        $form = $this->formConsultUsuarios($em);
       // $user = $this->get('security.token_storage')->getToken()->getUser()->getSede()->getId();

        $query = "SELECT u FROM AppBundle:Usuarios u "
                . "WHERE "
                . "u.cedula != 0 "                                 
                . "ORDER BY u.cedula ASC ";
        
        $entities = $em->createQuery($query); 
        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate($entities,$this->get('request')->query->get('page',1),10);
        
        return $this->render('AppBundle:Usuarios:index.html.twig', array(
            'form'=>$form->createView(),
            'pagination'=>$pagination
        ));
    }
    
    /**
     * 
     * @Route("/app/admin/usuarios/search/", name="app_admin_usuarios_search")
     */
    public function searchAction(Request $request){
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $text = $request->get('text');
        //$user = $this->get('security.token_storage')->getToken()->getUser()->getSede()->getId();

        
        $query = "SELECT u FROM AppBundle:Usuarios u "
                . " WHERE "
                . " u.cedula LIKE :text OR "
                . " u.nombre LIKE :text "
                . " ORDER BY u.cedula ASC ";
        
        $entities = $em->createQuery($query); 
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Usuarios:index.html.twig', array(            
            'pagination'=>$pagination   
        ));
    }    
    
    /**
     * @Route("/app/admin/usuarios/editar/{id}", name="app_usuarios_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);
        $form = $this->formEdit($entities, $em);
                    
        return $this->render('AppBundle:Usuarios:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }

     private function formEdit(Usuarios $entities, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new UsuariosType($em), $entities, array(
            'action'=>$this->generateUrl('app_usuarios_update_edit', array('id'=>$entities->getId())),
            'method'=>'PUT')) 
             ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')));
             
        return $form;
    }

    /**
     * @Route("/app/admin/usuarios/actualizar/{id}", name="app_usuarios_update_edit", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulausuario = $entities->getCedula();
	//echo $cedulausuario;die();
        $entities2 = $em2->getRepository('UsersBundle:Users')->findOneBy(array('cedula'=>$cedulausuario, 'email'=>$entities->getEmail()));
// 	var_dump($iduser); die();
     //   $entities2 = $em2->getRepository('UsersBundle:Users')->find($iduser->getId());


        $form = $this->formEdit($entities, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            
           if ($form->get('submit')->isClicked()) {
            $em->persist($entities);
            $em->flush();

            //$password = $this->get('request')->request->get('password');
            $password = $entities->getPassword();
            $email = $entities->getEmail();
            $cedula = $entities->getCedula();
            $nombre = $entities->getNombre().' '.$entities->getApellido();
            //$activo = $entities->getActivo();

            $encoder  = $this->get('security.encoder_factory')->getEncoder($entities2);
            $entities2->setSalt(md5(time()));
            $passwordCodifi = $encoder->encodePassword($password, $entities2->getSalt());
            $entities2->setPassword($passwordCodifi);
            $entities2->setEmail($email);
            $entities2->setCedula($cedula);
            $entities2->setNombre($nombre);
            //$entities2->setActive($activo);

            $em2->persist($entities2);
            $em2->flush();

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
           } 
            
            return $this->redirect($this->generateUrl('app_usuarios_show'));
        }
        
        return $this->render('AppBundle:Usuarios:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formConsultUsuarios(\Doctrine\ORM\EntityManager $em){
        $form = $this->createFormBuilder()
            ->add('cedula', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('nombre', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('apellido', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('password', 'text', array('attr'=>array('class'=>'form-control')))
            ->add('email', 'text', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm();
        return $form;
    }

/*SIN USAR SIN USAR SIN USAR
    
     /**
     * Finds and displays a Usuarios entity.
     *
     * @Route("/app/admin/usuarios/", name="app_usuarios_show")
     
    public function showAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entity = $em->getRepository('AppBundle:Usuarios')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Usuarios entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('AppBundle:Usuarios:show.html.twig', array(
            'entity'      => $entity,
            'delete_form' => $deleteForm->createView(),
        ));
    }
    
    /**
     * Deletes a Usuarios entity.
     *
     * @Route("/app/admin/usuarios/eliminar", name="app_usuarios_eliminar")
     
    public function deleteAction(Request $request, $id)
    {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $entity = $em->getRepository('AppBundle:Usuarios')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Usuarios entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('usuarios'));
    }

    /**
     * Creates a form to delete a Usuarios entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     * @Route("/app/admin/usuarios", name="app_usuarios_delete")
     
    private function createDeleteForm($id)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('app_usuarios_delete', array('id' => $id)))
            ->setMethod('DELETE')
            ->add('submit', 'submit', array('label' => 'Delete'))
            ->getForm()
        ;
    }

  SIN USAR SIN USAR SIN USAR*/



    /**
     * @Route("/app/admin/defaultusuarios/usuario", name="app_usuario_default")
     */
    public function defaultUsuariosAction()
    {
        $form = $this->formSearchUsuarios();
        return $this->render('AppBundle:Usuarios:usuariodefault.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchUsuarios()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_usuario_default_search'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat pull-center')))
                ->getForm()
            ;
        return $form;
    }

    /**
     * @Route("/app/admin/search/defaultusuarios/usuario", name="app_usuario_default_search", requirements={"_method":"POST"})
     */
    public function searchDefaultUsuariosAction(Request $request)
    {
        $form = $this->formSearchUsuarios();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $usuario = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
             $this->get('session')->set('datos', $usuario);
            if(!$usuario){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_usuario_default'));
            }
            
            return $this->redirect($this->generateUrl('app_usuarios_default', array('id'=>$usuario->getId())));
        }

        $this->get('session')->getFlashBag()->add('msg-error', 'INGRESAR SÓLO DATOS NUMÉRICOS!');
        return $this->render('AppBundle:Usuarios:usuariodefault.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/usuarios/default/", name="app_usuarios_default")
     */
    public function defaultAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $id = $request->get('id');
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);
        $form = $this->formDefault($entities, $em);
                    
        return $this->render('AppBundle:Usuarios:default.html.twig', array(
            'form'=>$form->createView()
        ));
    }

     private function formDefault(Usuarios $entities, \Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createForm(new UsuariosType($em), $entities, array(
            'action'=>$this->generateUrl('app_usuarios_update_default', array('id'=>$entities->getId())),
            'method'=>'PUT')) 
             ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')));
             
        return $form;
    }

    /**
     * @Route("/app/admin/usuarios/pordefecto/{id}", name="app_usuarios_update_default", requirements={"_method":"PUT"})
     */
    public function updateDefaultAction($id, Request $request)
    {

        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Usuarios')->find($id);

        $em2 = $this->getDoctrine()->getManager();
        $cedulausuario = $entities->getCedula();
        $user = new Users();

        $form = $this->formDefault($entities, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            
           if ($form->get('submit')->isClicked()) {

            $email = $entities->getEmail();
            $cedula = $entities->getCedula();
            $nombre = $entities->getNombre().' '.$entities->getApellido();
            $issetUsuario = $em2->getRepository('UsersBundle:Users')->findBy(['email'=>$email]);

                if(!$issetUsuario){

                    $user->setPassword('Uf1vaGnEInV9dFNFQJzqbcqFAHMVwMgULoo+gjhnb5jufBqQ26sqGI4kk0q7HENNZ/9nI2Azd5N/VRQI+TdE1w==');
                    $user->setSalt('fa34eb5f39aff72e95c8437eda86882b');
                    $user->setEmail($email);
                    $user->setCedula($cedula);
                    $user->setNombre($nombre);

                    $role = $em2->getRepository('UsersBundle:Role')->findOneBy(array('name'=>'ROLE_ADMIN'));
                    $user->addUserRole($role);
                    $user->setSede($this->getUser()->getSede());
                    $user->setActive(1);

                    $em2->persist($user);
                    $em2->flush();
                    }else{

                        $this->get('session')->getFlashBag()->add('msg-error', 'Correo ya registrado');

                        return $this->redirect($this->generateUrl('app_usuario_default'));
                    }
            $entities->setPassword('23181');
            $em->persist($entities);
            $em->flush();
            $em2->flush();

            }

            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_usuarios_show'));
        }
        
        return $this->render('AppBundle:Usuarios:default.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
}
