<?php
namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Sede;
use AppBundle\Form\SedeType;

/**
 * Description of SedeController
 *
 * @author jose
 */
class SedeController extends Controller {
    


    /**
     *  @Route("/app/admin/sede", name="app_admin_sede_index")
     */
    public function indexAction()
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT l FROM AppBundle:Sede l "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Sede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     *  @Route("/app/admin/search/sede", name="app_admin_sede_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT l FROM AppBundle:Sede l "
                . "WHERE "
                . "l.codigo LIKE :text "
                . "ORDER BY l.codigo DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Sede:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/sede/{id}", name="app_admin_sede_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Sede')->find($id);        
        $form = $this->editForm($entity);
        
        return $this->render('AppBundle:Sede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/sede/{id}", name="app_admin_sede_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Sede')->find($id);        
        $form = $this->editForm($entity);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_sede_index'));
        }
        
        return $this->render('AppBundle:Sede:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Sede $entity)
    {
        $form = $this->createForm(new SedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_sede_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/sede", name="app_admin_sede_new")
     */
    public function newAction()
    {
        $entity = new Sede();
        $form = $this->newForm($entity);
        
        return $this->render('AppBundle:Sede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/sede", name="app_admin_sede_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new Sede();
        $form = $this->newForm($entity);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro creado con exito!');
            return $this->redirect($this->generateUrl('app_admin_sede_index'));
        }
        
        return $this->render('AppBundle:Sede:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(Sede $entity)
    {
        $form = $this->createForm(new SedeType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_sede_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
}