<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Form\EstudianteType;  
use AppBundle\Entity\Estudiante;
use AppBundle\Entity\EspeEstud;
use AppBundle\Form\EspeEstudType;
/**
 * Description of Estudiantes
 *
 * @author josemorlet
 */
class EstudiantesController extends Controller {
    
    /**
     * @Route("/app/admin/estudiantes", name="app_estudiantes_index")
     */
    public function indexAction()
    {
        $form = $this->formSearchEstudiante();
        return $this->render('AppBundle:Estudiantes:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    


    /**
     * @Route("/app/admin/search/estudiante", name="app_estudiante_search", requirements={"_method":"POST"})
     */
    public function searchEstudiantesAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
             $this->get('session')->set('datos', $estudiante);
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_index'));
            }
            
            return $this->render('AppBundle:Estudiantes:result.html.twig', array(
                'datos'=>$estudiante
            ));
        }

        $this->get('session')->getFlashBag()->add('msg-error', 'INGRESAR SÓLO DATOS NUMÉRICOS!');
        return $this->render('AppBundle:Estudiantes:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formSearchEstudiante()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_estudiante_search'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
            ;
        return $form;
    }

    /**
     * @Route("/app/admin/editestu/estudiantes", name="app_estudiantes_editestu")
     */
    public function editEstuAction()
    {
        $form = $this->formSearchEditEstu();
        return $this->render('AppBundle:Estudiantes:editestu.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    


    /**
     * @Route("/app/admin/search/editestu/estudiante", name="app_estudiante_search_edit", requirements={"_method":"POST"})
     */
    public function searchEditEstuAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
             $this->get('session')->set('datos', $estudiante);
            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_editestu'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->getEstudianteEspeEstud($estudiante->getId());

            foreach ($espeestud as $v){

                $inscrito = $em->getRepository('AppBundle:Matricula')->findOneBy(array('estudiante'=>$v->getId()));

            }

            if($inscrito){
                return $this->render('AppBundle:Estudiantes:resultedit2.html.twig', array(
                'datos'=>$estudiante,
                'espe'=>$espeestud));
            }
            
            return $this->render('AppBundle:Estudiantes:resultedit.html.twig', array(
                'datos'=>$estudiante
            ));
        }

        $this->get('session')->getFlashBag()->add('msg-error', 'INGRESAR SÓLO DATOS NUMÉRICOS!');
        return $this->render('AppBundle:Estudiantes:editestu.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formSearchEditEstu()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_estudiante_search_edit'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
            ;
        return $form;
    }

    
    /**
     * @Route("/app/admin/edit/estudiante/{id}", name="app_estudiante_edit")
     */
    public function editEstudianteAction($id){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEditEstudiante($entity, $em);
        
        return $this->render('AppBundle:Estudiantes:edit.html.twig', array(
            'form'=>$form->createView(),
        ));
    }

    /**
     * @Route("/app/admin/update/estudiante/{id}", name="app_estudiante_update", requirements={"_method":"POST"})
     */
    public function updateEstudianteAction(Request $request, $id)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEditEstudiante($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
           $em->persist($entity);
           $em->flush();
           $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado sastifactoriamente!');
           return $this->render('AppBundle:Estudiantes:resultedit.html.twig', array(
                'datos'=>$entity
            ));
        }else{
            $this->get('session')->getFlashBag()->add('msg-error','Verifique que los datos estan correctos!');
        }
        return $this->render('AppBundle:Estudiantes:edit.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    private function formEditEstudiante(Estudiante $entity, \Doctrine\ORM\EntityManager $em){
        $form = $this->createForm(new EstudianteType($em), $entity, array(
                    'em'=>$em,
                    'action' =>$this->generateUrl('app_estudiante_update', array('id'=>$entity->getId())),
                    'method' =>'POST'
                ))
                ->add('submit', 'submit', array( 'attr'=> array(
                    'class'=>'btn btn-primary btn-flat',
                                        )))
                ;
        return $form;
    }

    /**
     * @Route("/app/admin/edit2/estudiante/{id}", name="app_estudiante_edit2")
     */
    public function edit2EstudianteAction($id){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));

        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEdit2Estudiante($entity, $em);
        
        return $this->render('AppBundle:Estudiantes:edit2.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    /**
     * @Route("/app/admin/update2/estudiante/{id}", name="app_estudiante_update2", requirements={"_method":"POST"})
     */
    public function update2EstudianteAction(Request $request, $id)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Estudiante')->find($id);
        $form = $this->formEditEstudiante($entity, $em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
           $em->persist($entity);
           $em->flush();
           $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado sastifactoriamente!');
           return $this->render('AppBundle:Estudiantes:resultedit2.html.twig', array(
                'datos'=>$entity
            ));
        }else{
            $this->get('session')->getFlashBag()->add('msg-error','Verifique que los datos estan correctos!');
        }
        return $this->render('AppBundle:Estudiantes:edit2.html.twig', array(
            'form'=>$form->createView(),
        ));
    }
    
    private function formEdit2Estudiante(Estudiante $entity, \Doctrine\ORM\EntityManager $em){
        $form = $this->createForm(new EstudianteType($em), $entity, array(
                    'em'=>$em,
                    'action' =>$this->generateUrl('app_estudiante_update2', array('id'=>$entity->getId())),
                    'method' =>'POST'
                ))
                ->add('submit', 'submit', array( 'attr'=> array(
                    'class'=>'btn btn-primary btn-flat',
                                        )))
                ;
        return $form;
    }


    


     /**
     * @Route("/app/admin/new/estudiante/", name="app_estudiante_new")
     */
    public function newAction()
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Estudiante();   
        $espeEstud = new EspeEstud();
        $entity->getEspeestud()->add($espeEstud);
        $form = $this->formCreateEstudianteDatosBasic($entity, $em);        
        
        return $this->render('AppBundle:Estudiantes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/estudiante", name="app_estudiante_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Estudiante();        
        $form = $this->formCreateEstudianteDatosBasic($entity, $em); 
        
        $form->handleRequest($request);
        if($form->isValid()){            
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado exitosamente!');
            return $this->redirect($this->generateUrl('app_estudiantes_index'));
        }
        
        return $this->render('AppBundle:Estudiantes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }


    private function formCreateEstudianteDatosBasic(Estudiante $entity,  \Doctrine\ORM\EntityManager $em){
        
       
        $form = $this->createForm(new EstudianteType($em), $entity, array(
                    'action' =>$this->generateUrl('app_estudiante_create'),
                    'method' =>'POST'
                ))
                ->add('submit', 'submit', array('label'=>'Guardar Cambios', 'attr'=> array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }    
    
    /**
     * @Route("/app/admin/select/especialidad", name="select_especialidad")
     */
     public function selectEspecialidadAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('programa_id');
         $especialidades= $em->getRepository('AppBundle:Especialidad')->findBy(array('programa'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
     
    /**
     * @Route("/app/admin/select/estados", name="select_estados")
     */
     public function selectEstadosAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('pais_id');
         $especialidades= $em->getRepository('AppBundle:Estados')->findBy(array('pais'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
     
    /**
     * @Route("/app/admin/select/ciudades", name="select_ciudades")
     */
     public function selectCiudadesAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('estado_id');
         $especialidades= $em->getRepository('AppBundle:Ciudades')->findBy(array('estado'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
    /**
     * @Route("/app/admin/select/municipios", name="select_municipios")
     */
     public function selectMunicipiosAction(Request $request)
     {
         $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
         $programa = $request->get('estado_id');
         $especialidades= $em->getRepository('AppBundle:Municipios')->findBy(array('estado'=>$programa));

         foreach($especialidades as $value)
            {
                $dato['id'] = $value->getId();
                $dato['text'] = $value->getNombre();
                $response[] = $dato;
            }       
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        
        return $respuesta;   
     }
     
     
    //CAMBIO DE ESPACIALIDAD

    /**
    * @Route("/app/admin/cambioespe/estudiantes", name="app_estudiantes_cambio_especialidad")
    */
    public function cambioEspeAction()
    {
        $form = $this->formSearchCambioEspe();
        return $this->render('AppBundle:Estudiantes:cambio_especialidad.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchCambioEspe()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_estudiante_search_cambio'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
            ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/search/cambioespe/estudiante", name="app_estudiante_search_cambio", requirements={"_method":"POST"})
     */
    public function searchCambioEspeAction(Request $request)
    {
        $form = $this->formSearchEstudiante();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            $algo = '';

            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_cambio_especialidad'));
            }

            $espeestud = $em->getRepository('AppBundle:EspeEstud')->getEstudianteEspeEstud($estudiante->getId());

            foreach ($espeestud as $value){
                $this->get('session')->set('espe_id', $value->getEspecialidad()->getId());

                $semestre = $em->getRepository('AppBundle:PlanEstudio')->consultSemestre($value->getEspecialidad()->getId());
                $cursosAplazados = $em->getRepository('AppBundle:Matricula')->findMatriculaEstudAplazado($value->getId());
                $matricula = $em->getRepository('AppBundle:Matricula')->getHistorico($value->getId());

                if($cursosAplazados){

                    $this->get('session')->getFlashBag()->add('msg-error', 'POSEE CURSOS APLAZADOS');
                
                    return $this->redirect($this->generateUrl('app_estudiantes_cambio_especialidad', array()));

                }else{

                    foreach ($semestre as $cursos){
                        foreach ($matricula as $cursosm){

                            $algo = $cursos->getSemestre();

                            if ($cursos->getCurso()->getId() == $cursosm->getOferta()->getCurso()->getId() && $cursos->getSemestre() > '2'){

                                $this->get('session')->getFlashBag()->add('msg-error', 'NO PROCEDE EL CAMBIO DE ESPECIALIDAD');
                
                                return $this->redirect($this->generateUrl('app_estudiantes_cambio_especialidad', array()));

                            }
                        }
                    }
                }
            $this->get('session')->getFlashBag()->add('msg-success', 'PROCEDE EL CAMBIO DE ESPECIALIDAD');
            return $this->redirect($this->generateUrl('app_estudiantes_editar_especialidad', array('id'=>$value->getId())));

            }            
            
        }

        $this->get('session')->getFlashBag()->add('msg-error', 'INGRESAR SÓLO DATOS NUMÉRICOS!');
        return $this->redirect($this->generateUrl('app_estudiantes_cambio_especialidad', array()));
    }

    /**
     * @Route("/app/admin/cambioespe/estudiante/", name="app_estudiantes_editar_especialidad")
     */
    public function editEstudianteEspeAction(Request $request){
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $id = $request->get('id');
        $entity = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $form = $this->formEditEstuEspe($em, $entity);
        
        return $this->render('AppBundle:Estudiantes:editespe.html.twig', array(
            'form'=>$form->createView(),
        ));
    }

    private function formEditEstuEspe(\Doctrine\ORM\EntityManager $em, EspeEstud $entity){
        $form = $this->createForm(new EspeEstudType($em), $entity, array(
            'method'=>'POST', 
            'action'=>$this->generateUrl('app_estudiante_update_espe', array('id'=>$entity->getId())

        )))     
                ->add('submit', 'submit', array( 'attr'=> array(
                    'class'=>'btn btn-primary btn-flat',
                                        )))
                ;
        return $form;
    }

    /**
     * @Route("/app/admin/updateespe/estudiante/{id}", name="app_estudiante_update_espe", requirements={"_method":"POST"})
     */
    public function updateEstudianteEspeAction(Request $request, $id)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $espe_id = $this->get('session')->get('espe_id');
        $entity = $em->getRepository('AppBundle:EspeEstud')->find($id);
        $form = $this->formEditEstuEspe($em, $entity);
        
        $form->handleRequest($request);
        if($form->isValid())
        {

            $em->persist($entity);
            $em->flush();

            $cedula = $this->getUser()->getCedula();
            $ids = $em->getRepository('AppBundle:Usuarios')->findOneBy(array('cedula'=>$cedula));
            $usuarios = $em->getRepository('AppBundle:Usuarios')->find($ids);
            $espe_ini = $em->getRepository('AppBundle:Especialidad')->find($espe_id);
            $especialidad = $entity->getEspecialidad();
            $cohorte = $entity->getCohorte();
            $lapso = $entity->getCodLapso();
            $ingreso = $entity->getIngreso();

            $newAuditoria = new \AppBundle\Entity\AuditoriaEspe();                      
            $newAuditoria->setUsuarios($usuarios);
            $newAuditoria->setEstudiante($entity);
            $newAuditoria->setEspecialidadIni($espe_ini);
            $newAuditoria->setEspecialidadActual($especialidad);
            $newAuditoria->setCohorte($cohorte);
            $newAuditoria->setLapso($lapso);
            $newAuditoria->setIngreso($ingreso);
            $newAuditoria->setFechaHora(new \DateTime());


                $em->persist($newAuditoria);
                $em->flush();
            

           $this->get('session')->getFlashBag()->add('msg-success','Registro modificado sastifactoriamente!');
           return $this->redirect($this->generateUrl('app_estudiantes_cambio_especialidad'));

        }else{
            $this->get('session')->getFlashBag()->add('msg-error','Verifique que los datos estan correctos!');
        }
        return $this->render('AppBundle:Estudiantes:editespe.html.twig', array(
            'form'=>$form->createView(),
        ));
    }

    //NUEVA ESPACIALIDAD

    /**
    * @Route("/app/admin/nuevaespe/estudiantes", name="app_estudiantes_new_especialidad")
    */
    public function nuevaEspeAction()
    {
        $form = $this->formSearchNuevaEspe();
        return $this->render('AppBundle:Estudiantes:NuevaEspe/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    private function formSearchNuevaEspe()
    {
        $form = $this->createFormBuilder()
                ->setAction($this->generateUrl('app_estudiante_search_nueva'))
                ->setMethod('POST')
                ->add('cedula', 'number', array('attr'=>array('class'=>'form-control')))
                ->add('submit', 'submit', array('label'=>'Consultar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ->getForm()
            ;
        return $form;
    }

    /**
     * @Route("/app/admin/nuevaespe/especialidad", name="app_estudiante_search_nueva", requirements={"_method":"POST"})
     */
    public function searchEspecialidadAction(Request $request)
    {


        $form = $this->formSearchNuevaEspe();
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $cedula = $form['cedula']->getData();
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $estudiante = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
            $this->get('session')->set('datosEstudiante', $estudiante);
            $lapsoact = $em->getRepository('AppBundle:Lapso')->findOneBy(array('activo'=>1));
            $especialidadact = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('activo'=>1));

            if(!$estudiante){
                $this->get('session')->getFlashBag()->add('msg-error', 'Cédula no encontrada.!');
                return $this->redirect($this->generateUrl('app_estudiantes_new_especialidad'));
            }
            
            return $this->render('AppBundle:Estudiantes:NuevaEspe/result.html.twig', array(
                'datos'=>$estudiante,
                'lapso'=>$especialidadact,
                'periodo'=>$lapsoact,

            ));
        }
        
        return $this->render('AppBundle:Estudiantes:NuevaEspe/index.html.twig', array(
            'form'=>$form->createView()
        ));
    }

    /**
     * @Route("/app/especialidad", name="app_estudiante_index")
     */
    public function especialidadAction(Request $request)
    {

        $entity = new EspeEstud();
        $especialidad = $request->get('especialidad');
     
        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $estudiante = $this->get('session')->get('datosEstudiante');
        $cedula = $estudiante->getCedula();
        $datosEstu = $em->getRepository('AppBundle:Estudiante')->findOneBy(array('cedula'=>$cedula));
        $rut = $estudiante->getId();
        $espe = $em->getRepository('AppBundle:EspeEstud')->findOneBy(array('estudiante'=>$rut));
        $id = $espe->getId();

        $repo = $em->getRepository('AppBundle:EspeEstud');

        $qb = $repo->createQueryBuilder('e');
        $qb->update()
            ->set('e.activo', ':activo')
            ->where( 'e.estudiante = :estudiante AND e.activo = :activo2')
            ->setParameter('estudiante', $rut)
            ->setParameter('activo', '0')
            ->setParameter('activo2', '1');
            $qb->getQuery()->execute(); 
        $em->flush();
        

        $form = $this->formEspecialidadEstudiante($em,$entity,$request->get('especialidad'));

        
        if($request->getMethod() == 'POST')
        {
            $form->handleRequest($request);
            
            if($form->isValid())
            {

                $espeestud = $em->getRepository('AppBundle:Estudiante')->find($form['id']->getData());
             
                $data = $form->getData();
                $entity->setEstudiante($espeestud);
                $entity->setActivo('1');
          
                $em->persist($entity);
                $em->flush();

                return $this->render('AppBundle:Estudiantes:NuevaEspe/exito.html.twig', array(
                'datos'=>$datosEstu,
            ));
                
            }
        }

        
        return $this->render('AppBundle:Estudiantes:NuevaEspe/new_especialidad.html.twig', array(
            'form'=>$form->createView(),
            'datos'=>$estudiante,

           
        ));
       // echo "OK";
    }

    private function formEspecialidadEstudiante(\Doctrine\ORM\EntityManager $em, EspeEstud $entity, $especialidad)
    {
        $form = $this->createForm(new EspeEstudType($em), $entity, array(
            'method'=>'POST', 
            'action'=>$this->generateUrl('app_estudiante_index', array('especialidad'=>$especialidad)
        )))
 
        ->add('id', 'hidden', array('data'=>$especialidad, 'mapped'=>false))
        ->add('activo', 'hidden') 


        ->add('submit', 'submit', array('label'=>'Asignar','attr'=>array('class'=>'btn btn-primary btn-flat', 'style'=>'margin-left:15px;')))
        ;
        return $form;
    }    
    
}
