<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="hist_egresado")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\HistEgresadoRepository")
 */
class HistEgresado {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="EspeEstud", inversedBy="histegresado")
     * @ORM\JoinColumn(name="estudiante_id", referencedColumnName="id")
     */
    protected $estudiante;
    
    /**
     * @ORM\ManyToOne(targetEntity="Promociones", inversedBy="histegresado")
     * @ORM\JoinColumn(name="promocion_id", referencedColumnName="id")
     */
    protected $promocion;    
   
    /**
     * @ORM\Column(type="float", scale=2, nullable=true)
     */
    protected $indice;
    
    /**
     * @ORM\Column(type="integer", nullable=true)
     */    
    protected $posicion_gen;
    
    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $total_gen;
                
    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    protected $posicion_esp;
    
    /**
     * @ORM\Column(type="integer", nullable=true)
     */    
    protected $total_esp;

    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set indice
     *
     * @param float $indice
     * @return HistEgresado
     */
    public function setIndice($indice)
    {
        $this->indice = $indice;
    
        return $this;
    }

    /**
     * Get indice
     *
     * @return float 
     */
    public function getIndice()
    {
        return $this->indice;
    }

    /**
     * Set posicion_gen
     *
     * @param integer $posicionGen
     * @return HistEgresado
     */
    public function setPosicionGen($posicionGen)
    {
        $this->posicion_gen = $posicionGen;
    
        return $this;
    }

    /**
     * Get posicion_gen
     *
     * @return integer 
     */
    public function getPosicionGen()
    {
        return $this->posicion_gen;
    }

    /**
     * Set total_gen
     *
     * @param integer $totalGen
     * @return HistEgresado
     */
    public function setTotalGen($totalGen)
    {
        $this->total_gen = $totalGen;
    
        return $this;
    }

    /**
     * Get total_gen
     *
     * @return integer 
     */
    public function getTotalGen()
    {
        return $this->total_gen;
    }

    /**
     * Set posicion_esp
     *
     * @param integer $posicionEsp
     * @return HistEgresado
     */
    public function setPosicionEsp($posicionEsp)
    {
        $this->posicion_esp = $posicionEsp;
    
        return $this;
    }

    /**
     * Get posicion_esp
     *
     * @return integer 
     */
    public function getPosicionEsp()
    {
        return $this->posicion_esp;
    }

    /**
     * Set total_esp
     *
     * @param integer $totalEsp
     * @return HistEgresado
     */
    public function setTotalEsp($totalEsp)
    {
        $this->total_esp = $totalEsp;
    
        return $this;
    }

    /**
     * Get total_esp
     *
     * @return integer 
     */
    public function getTotalEsp()
    {
        return $this->total_esp;
    }

    /**
     * Set estudiante
     *
     * @param \AppBundle\Entity\EspeEstud $estudiante
     * @return HistEgresado
     */
    public function setEstudiante(\AppBundle\Entity\EspeEstud $estudiante = null)
    {
        $this->estudiante = $estudiante;
    
        return $this;
    }

    /**
     * Get estudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEstudiante()
    {
        return $this->estudiante;
    }

    /**
     * Set promocion
     *
     * @param \AppBundle\Entity\Promociones $promocion
     * @return HistEgresado
     */
    public function setPromocion(\AppBundle\Entity\Promociones $promocion = null)
    {
        $this->promocion = $promocion;
    
        return $this;
    }

    /**
     * Get promocion
     *
     * @return \AppBundle\Entity\Promociones 
     */
    public function getPromocion()
    {
        return $this->promocion;
    }
}
