<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * exonerados
 *
 * @ORM\Table(name="exonerados")
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repository\ExoneradosRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Exonerados
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $resolucion;
    
    /**
     * @var string
     *
     * @ORM\Column(name="porcentaje", type="decimal", scale=2)
     */
    protected $porcentaje;

    /**
     * @ORM\ManyToOne(targetEntity="Lapso", inversedBy="exonerados")
     * @ORM\JoinColumn(name="lapso_id", referencedColumnName="id")
     */
    protected $lapso;

    /**
     * @ORM\ManyToOne(targetEntity="Sede", inversedBy="exonerados")
     * @ORM\JoinColumn(name="sede_id", referencedColumnName="id")
     */
    protected $sede;

    /**
     * @ORM\ManyToOne(targetEntity="TipoExoneracion", inversedBy="exonerados")
     * @ORM\JoinColumn(name="tipo_id", referencedColumnName="id")
     */
    protected $tipo;
    
    /**
     * @var AppBundle\Entity\EspeEstud especialidadEstudiante
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\EspeEstud",
     *     inversedBy="exonerados")
     * @ORM\JoinColumn(name="espeestud_id", referencedColumnName="id")
     */     
    protected $especialidadEstudiante;
    /**
     * @ORM\ManyToOne(targetEntity="SubSede", inversedBy="exonerados")
     * @ORM\JoinColumn(name="subsede_id", referencedColumnName="id")
     */
    protected $subsede;
    
    /**
     * @ORM\Column(type="datetime")
     */
    protected $fechainclucion;
    
    
    /**
     * @ORM\PrePersist()
     */
    public function onPersist(){
        $this->fechainclucion = new \DateTime();
    }
    
    


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set resolucion
     *
     * @param string $resolucion
     * @return Exonerados
     */
    public function setResolucion($resolucion)
    {
        $this->resolucion = $resolucion;
    
        return $this;
    }

    /**
     * Get resolucion
     *
     * @return string 
     */
    public function getResolucion()
    {
        return $this->resolucion;
    }

    /**
     * Set porcentaje
     *
     * @param string $porcentaje
     * @return Exonerados
     */
    public function setPorcentaje($porcentaje)
    {
        $this->porcentaje = $porcentaje;
    
        return $this;
    }

    /**
     * Get porcentaje
     *
     * @return string 
     */
    public function getPorcentaje()
    {
        return $this->porcentaje;
    }

    /**
     * Set sede
     *
     * @param string $sede
     * @return Exonerados
     */
    public function setSede($sede)
    {
        $this->sede = $sede;
    
        return $this;
    }

    /**
     * Get sede
     *
     * @return string 
     */
    public function getSede()
    {
        return $this->sede;
    }

    /**
     * Set fechainclucion
     *
     * @param \DateTime $fechainclucion
     * @return Exonerados
     */
    public function setFechainclucion($fechainclucion)
    {
        $this->fechainclucion = $fechainclucion;
    
        return $this;
    }

    /**
     * Get fechainclucion
     *
     * @return \DateTime 
     */
    public function getFechainclucion()
    {
        return $this->fechainclucion;
    }

    /**
     * Set lapso
     *
     * @param \AppBundle\Entity\Lapso $lapso
     * @return Exonerados
     */
    public function setLapso(\AppBundle\Entity\Lapso $lapso = null)
    {
        $this->lapso = $lapso;
    
        return $this;
    }

    /**
     * Get lapso
     *
     * @return \AppBundle\Entity\Lapso 
     */
    public function getLapso()
    {
        return $this->lapso;
    }

    /**
     * Set tipo
     *
     * @param \AppBundle\Entity\TipoExoneracion $tipo
     * @return Exonerados
     */
    public function setTipo(\AppBundle\Entity\TipoExoneracion $tipo = null)
    {
        $this->tipo = $tipo;
    
        return $this;
    }

    /**
     * Get tipo
     *
     * @return \AppBundle\Entity\TipoExoneracion 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set especialidadEstudiante
     *
     * @param \AppBundle\Entity\EspeEstud $especialidadEstudiante
     * @return Exonerados
     */
    public function setEspecialidadEstudiante(\AppBundle\Entity\EspeEstud $especialidadEstudiante = null)
    {
        $this->especialidadEstudiante = $especialidadEstudiante;
    
        return $this;
    }

    /**
     * Get especialidadEstudiante
     *
     * @return \AppBundle\Entity\EspeEstud 
     */
    public function getEspecialidadEstudiante()
    {
        return $this->especialidadEstudiante;
    }

    /**
     * Set subsede
     *
     * @param \AppBundle\Entity\SubSede $subsede
     *
     * @return Exonerados
     */
    public function setSubsede(\AppBundle\Entity\SubSede $subsede = null)
    {
        $this->subsede = $subsede;

        return $this;
    }

    /**
     * Get subsede
     *
     * @return \AppBundle\Entity\SubSede
     */
    public function getSubsede()
    {
        return $this->subsede;
    }
}
