<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\ORM\EntityRepository;
use AppBundle\Entity\PlanEstudio;
use AppBundle\Form\PlanEstudioType;
use AppBundle\Entity\Prelacion;

class PlanEstudioController extends Controller {
    
    /**
     * @Route("/app/choice/planestudio", name="app_plan_estudio_index")
     */
    public function indexAction()
    {        
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $form = $this->formChoicePlanEstudio($em);        
        
        return $this->render('AppBundle:PlanEstudio:index.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formChoicePlanEstudio(\Doctrine\ORM\EntityManager $em)
    {
        $form = $this->createFormBuilder()                
                ->add('programa', 'entity', array(
                    'class'=>'AppBundle:Programa',
                    'em'=>$em,
                    'empty_value'=>'Programa .:Seleccione:.',
                    'attr'=>array('class'=>'form-control', 'style'=>'width:30%;')
                ))
                ->add('especialidad', 'entity', array(
                    'class'=>'AppBundle:Especialidad',
                    'em'=>$em,
                    'attr'=>array('class'=>'form-control', 'style'=>'width:70%;'),
                    'empty_value'=>'Especialidad .:Seleccione:.',
                    'query_builder'=>function(EntityRepository $er){
                        $q = $er->createQueryBuilder('e')
                                ->leftJoin('e.programa', 'p')
                                ->where('p.id IS NULL ');
                        return $q;
                    }
                ))
                ->getForm()
                ;
        return $form;                        
    }
    
    /**
     * @Route("/app/planestudio/opt/materias", name="app_optener_materias_plan", requirements={"_method":"POST|GET"})
     */
    public function showPlanesAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        $programa = $request->get('programa_id');
        $especialidad = $request->get('especialidad_id');
        
        $especial = $em->getRepository('AppBundle:Especialidad')->find($especialidad);
        $materias = $em->getRepository('AppBundle:PlanEstudio')->consultMaterias($programa, $especialidad, $sede);
        
        return $this->render('AppBundle:PlanEstudio:optplan.html.twig', array(
            'materias'=>$materias,
            'especialidad'=>$especial,
            'programa_id'=>$programa,
            'especialidad_id'=>$especialidad
        ));
    }
    
    /**
     * @Route("/app/planestudio/delete/curso/{id}/{programa}/{especialidad}", name="app_plan_estudio_remove")
     */
    public function deleteCursoPlanEstudioAction($id, $programa, $especialidad)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        
        $entity = $em->getRepository('AppBundle:PlanEstudio')->find($id);
        $em->remove($entity);
        $em->flush();
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado con exito');        
        
        $ids = $this->getUser()->getSede()->getCodigo();
        $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
        
        $especial = $em->getRepository('AppBundle:Especialidad')->find($especialidad);
        $materias = $em->getRepository('AppBundle:PlanEstudio')->consultMaterias($programa, $especialidad,$sede);
        return $this->render('AppBundle:PlanEstudio:optplan.html.twig', array(
            'materias'=>$materias,
            'especialidad'=>$especial,
            'programa_id'=>$programa,
            'especialidad_id'=>$especialidad
        ));
    }
    
    /**
     * @Route("/app/planestudio/new/{programa}/{especialidad}", name="app_plan_estudio_new")
     */
    public function newAction($programa, $especialidad)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new PlanEstudio();
        $form = $this->formNewPlanEstudio($entity, $em, $programa, $especialidad);
        
        return $this->render('AppBundle:PlanEstudio:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/planestudio/create/{programa}/{especialidad}", name="app_plan_estudio_create", requirements={"_method":"POST|GET"})
     */
    public function createAction(Request $request, $programa, $especialidad)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new PlanEstudio();
        $form = $this->formNewPlanEstudio($entity, $em, $programa, $especialidad);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $prog = $em->getRepository('AppBundle:Programa')->find($programa);
            $espe = $em->getRepository('AppBundle:Especialidad')->find($especialidad);
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            
            $entity->setPrograma($prog);
            $entity->setEspecialidad($espe);
            $entity->setSede($sede);            
            list($codigo, $nomnbre) = explode('-', $form->get('cod_curso')->getData());
            $curso = $em->getRepository('AppBundle:Cursos')->findOneByCodigo($codigo);
            $entity->setCurso($curso);
            $em->persist($entity);                  
            $em->flush();
            
            if(is_array($request->get('prelacion'))){
                foreach ($request->get('prelacion') as $value){
                    $prelacion = new Prelacion();                                   
                    $cursoasig = $em->getRepository('AppBundle:PlanEstudio')->find($entity->getId());
                    $prelacion->setPlan($cursoasig);
                    list($codigo2, $nomnbre) = explode('-', $value);
                    $curso2 = $em->getRepository('AppBundle:Cursos')->findOneByCodigo($codigo2);
                    $prelacion->setCurso($curso2);
                    $em->persist($prelacion);                
                }            
            }
            $em->flush();
                        
            
            $this->get('session')->getFlashBag()->add('msg-success','Registro guardado sastifactoriamente!.');
            return $this->forward('AppBundle:PlanEstudio:showPlanes', array('programa_id'=>$programa, 'especialidad_id'=>$especialidad));            
        }
        
        return $this->render('AppBundle:PlanEstudio:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function formNewPlanEstudio(PlanEstudio $entity, \Doctrine\ORM\EntityManager $em, $programa, $especialidad)
    {
        $form = $this->createForm(new PlanEstudioType($em), $entity, array(
                    'action'=>$this->generateUrl('app_plan_estudio_create', array('programa'=>$programa, 'especialidad'=>$especialidad)),
                    'method'=>'GET'
                ))
                ->add('cod_curso', 'text', array(
                    'mapped'=>false,
                ))                
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat pull-left','style'=>'margin-top:34px;')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/planestudio/edit/{programa}/{especialidad}/{id}", name="app_plan_estudio_edit")
     */
    public function editAction($programa, $especialidad, $id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:PlanEstudio')->find($id);
        $form = $this->formEditPlanEstudio($entity, $em, $programa, $especialidad);
        
        return $this->render('AppBundle:PlanEstudio:edit.html.twig', array(
            'form'=>$form->createView(),
            'entity'=>$entity,
        ));
    }
    
    /**
     * @Route("/app/planestudio/update/{programa}/{especialidad}/{id}", name="app_plan_estudio_update")
     */
    public function updateAction(Request $request, $programa, $especialidad, $id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:PlanEstudio')->find($id);
        $form = $this->formEditPlanEstudio($entity, $em, $programa, $especialidad);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $prog = $em->getRepository('AppBundle:Programa')->find($programa);
            $espe = $em->getRepository('AppBundle:Especialidad')->find($especialidad);
            $ids = $this->getUser()->getSede()->getCodigo();
            $sede = $em->getRepository('AppBundle:Sede')->findOneByCodigo($ids);
            
            $entity->setPrograma($prog);
            $entity->setEspecialidad($espe);
            $entity->setSede($sede);            
            list($codigo, $nomnbre) = explode('-', $form->get('cod_curso')->getData());
            $curso = $em->getRepository('AppBundle:Cursos')->findOneByCodigo($codigo);
            $entity->setCurso($curso);
            $em->persist($entity);                  
            $em->flush();
            
            $prelacionOld = $em->getRepository('AppBundle:Prelacion')->findBy(array('plan'=>$entity->getId()));
            foreach ($prelacionOld as $p){
                $em->remove($p);
            }
            $em->flush();
            
            if(is_array($request->get('prelacion'))){
                foreach ($request->get('prelacion') as $value){
                    $prelacion = new Prelacion();                                   
                    $cursoasig = $em->getRepository('AppBundle:PlanEstudio')->find($entity->getId());
                    $prelacion->setPlan($cursoasig);
                    list($codigo2, $nomnbre) = explode('-', $value);
                    $curso2 = $em->getRepository('AppBundle:Cursos')->findOneByCodigo($codigo2);
                    $prelacion->setCurso($curso2);
                    $em->persist($prelacion);                
                }            
            }
            $em->flush();
                        
            
            $this->get('session')->getFlashBag()->add('msg-success','Registro guardado sastifactoriamente!.');
            return $this->forward('AppBundle:PlanEstudio:showPlanes', array('programa_id'=>$programa, 'especialidad_id'=>$especialidad));            
        }
        
        return $this->render('AppBundle:PlanEstudio:edit.html.twig', array(
            'form'=>$form->createView(),
            'entity'=>$entity,
        ));
    }
    
    
    
    private function formEditPlanEstudio(PlanEstudio $entity, \Doctrine\ORM\EntityManager $em, $programa, $especialidad)
    {
        $form = $this->createForm(new PlanEstudioType($em), $entity, array(
                    'action'=>$this->generateUrl('app_plan_estudio_update', array('programa'=>$programa, 'especialidad'=>$especialidad, 'id'=>$entity->getId())),
                    'method'=>'GET'
                ))
                ->add('cod_curso', 'text', array(
                    'mapped'=>false,
                    'data'=>$entity->getCurso(),
                ))                
                ->add('submit', 'submit', array('label'=>'Modificar','attr'=>array('class'=>'btn btn-primary btn-flat pull-left','style'=>'margin-top:34px;')))
                ;
        return $form;
    }
    
}
