<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Cursos;
use AppBundle\Form\CursosType;

class CursosController extends Controller {
    
    /**
     * @Route("/app/admin/unidadcurricular", name="app_cursos")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT c FROM AppBundle:Cursos c "                                        
                . "ORDER BY c.codigo ASC";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Cursos:index.html.twig', array(
            'pagination'=>$pagination
        ));               
    }
    
    /**
     * @Route("/app/admin/search", name="app_cursos_search")
     */
    public function searchAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT c FROM AppBundle:Cursos c "                                        
                . "WHERE "
                . "c.codigo LIKE :text OR "
                . "c.nombre LIKE :text "
                . "ORDER BY c.codigo ASC";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Cursos:index.html.twig', array(
            'pagination'=>$pagination
        ));               
    }
    
    /**
     * @Route("/app/admin/new/unidadcurricular", name="app_cursos_new")
     */
    public function newAction()
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Cursos();
        $form = $this->createFormA($entity, $em);        
        
        return $this->render('AppBundle:Cursos:new.html.twig', array(
           'form'=>$form->createView(), 
        ));
    }
    
    /**
     * @Route("/app/admin/create/unidadurricular", name="app_cursos_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $em = $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = new Cursos();
        $form = $this->createFormA($entity, $em);        
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $ids = $this->getUser()->getSede()->getId();
            $sede = $em->getRepository('AppBundle:Sede')->find($ids);
            $entity->setSede($sede);
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro guardado exitosamente!!');
            return  $this->redirect($this->generateUrl('app_cursos'));
        }
        
        return $this->render('AppBundle:Cursos:new.html.twig', array(
           'form'=>$form->createView(), 
        ));
    }
    
   

    private function createFormA(Cursos $entity,  \Doctrine\ORM\EntityManager $em)
    {
        $form =$this->createForm(new CursosType($em), $entity, array(
                    'action'=>$this->generateUrl('app_cursos_create'),
                    'method'=>'POST'
                ))
                ->add('submit', 'submit', array('label'=>'Crear','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/edit/unidadcurricular/{id}", name="app_cursos_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Cursos')->find($id);
        $form = $this->editFormA($entity,$em);
        
        return $this->render('AppBundle:Cursos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/unidadcurricular/{id}", name="app_cursos_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Cursos')->find($id);
        $form = $this->editFormA($entity,$em);
        
        $form->handleRequest($request);
        if($form->isValid())
        {   
            $em->persist($entity);
            $em->flush();
            
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado exitosamente!!');
            return  $this->redirect($this->generateUrl('app_cursos'));
        }
        
        return $this->render('AppBundle:Cursos:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editFormA(Cursos $entity,\Doctrine\ORM\EntityManager $em)
    {
        $form =$this->createForm(new CursosType($em), $entity, array(
                    'action'=>$this->generateUrl('app_cursos_update', array('id'=>$entity->getId())),
                    'method'=>'PUT'
                ))
                ->add('submit', 'submit', array('label'=>'Modificar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/opt/all/unidadcurricular/get", name="app_opt_all_cursos")
     */    
    public function optAllChildren()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entities = $em->getRepository('AppBundle:Cursos')->findAll(); 
        if(count($entities) > 0){
            foreach ($entities as $value)
            {            
                $dato['codigo'] = $value->getCodigo().'-'.$value->getNombre();
                $dato['nombre'] = $value->getNombre();
                
                $response[] = $dato;
            }
        }else{
            $dato['codigo'] = NULL;            
            $dato['nombre'] = NULL;            
            $response[] = $dato;
        }
        
        $respuesta = new Response(json_encode($response));
        $respuesta->headers->set('Content-Type', 'application/json');
        return $respuesta;
    }
    



   /**
     * @Route("/app/admin/cursos/delete/{id}", name="app_cursos_delete")
     */
    public function deleteCursosAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Cursos')->find($id);


        $url = $request->headers->get('referer');
        $findme   = '/new/';
        $pos = strpos($url, $findme); 
            $em->remove($entity);
            $em->flush(); 
        $this->get('session')->getFlashBag()->add('msg-success', 'Registro eliminado de forma exitosa!');

    }





}
