<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use AppBundle\Entity\Cohorte;
use AppBundle\Form\CohorteType;

/**
 * Description of CohorteController
 *
 * @author jose
 */
class CohorteController extends Controller {
    
    /**
     * @Route("/app/admin/cohortes", name="app_admin_cohorte_index")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $query = "SELECT c FROM AppBundle:Cohorte c "
                . "ORDER BY c.codigo DESC ";
        $entities = $em->createQuery($query);        
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Cohortes:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     *  @Route("/app/admin/search/cohortes", name="app_admin_cohorte_search_index")
     */
    public function searchAction(Request $request)
    {  
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        //$entities = $em->getRepository('AppBundle:Children')->findAllChildren();        
        $text = $request->get('text');
        $query = "SELECT c FROM AppBundle:Cohorte c "
                . "WHERE "
                . "c.codigo LIKE :text "
                . "ORDER BY c.codigo DESC ";
        $entities = $em->createQuery($query);        
        $entities->setParameter('text', '%'.$text.'%');
        
        $paginator = $this->container->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities,
                $this->get('request')->query->get('page',1),
                10          
        );
        
        return $this->render('AppBundle:Cohortes:index.html.twig', array(
            'pagination'=>$pagination
        ));
    }
    
    /**
     * @Route("/app/admin/edit/cohorte/{id}", name="app_admin_cohorte_edit")
     */
    public function editAction($id)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Cohorte')->find($id);        
        $form = $this->editForm($entity);
        
        return $this->render('AppBundle:Cohortes:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/update/cohorte/{id}", name="app_admin_cohorte_update", requirements={"_method":"PUT"})
     */
    public function updateAction($id, Request $request)
    {
        $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
        $entity = $em->getRepository('AppBundle:Cohorte')->find($id);        
        $form = $this->editForm($entity);
        
        $form->handleRequest($request);
        
        if($form->isValid())
        {
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro modificado con exito!');
            return $this->redirect($this->generateUrl('app_admin_cohorte_index'));
        }
        
        return $this->render('AppBundle:Cohortes:edit.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function editForm(Cohorte $entity)
    {
        $form = $this->createForm(new CohorteType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_cohorte_update', array('id'=>$entity->getId())),
            'method'=>'PUT'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
    
    /**
     * @Route("/app/admin/new/cohorte", name="app_admin_cohorte_new")
     */
    public function newAction()
    {
        $entity = new Cohorte();
        $form = $this->newForm($entity);
        
        return $this->render('AppBundle:Cohortes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    /**
     * @Route("/app/admin/create/cohorte", name="app_admin_cohorte_create", requirements={"_method":"POST"})
     */
    public function createAction(Request $request)
    {
        $entity = new Cohorte();
        $form = $this->newForm($entity);
        
        $form->handleRequest($request);
        if($form->isValid())
        {
            $em = $this->getDoctrine()->getManager($this->get('session')->get('em'));
            $em->persist($entity);
            $em->flush();
            $this->get('session')->getFlashBag()->add('msg-success', 'Registro creado con exito!');
            return $this->redirect($this->generateUrl('app_admin_cohorte_index'));
        }
        
        return $this->render('AppBundle:Cohortes:new.html.twig', array(
            'form'=>$form->createView()
        ));
    }
    
    private function newForm(Cohorte $entity)
    {
        $form = $this->createForm(new CohorteType(), $entity, array(
            'action'=>$this->generateUrl('app_admin_cohorte_create'),
            'method'=>'POST'
        ))
                ->add('submit', 'submit', array('label'=>'Guardar','attr'=>array('class'=>'btn btn-primary btn-flat')))
                ;
        return $form;
    }
}
